/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.synchronised.resourceserver;

import com.c4_soft.springaddons.security.oidc.OpenidClaimSet;
import com.c4_soft.springaddons.security.oidc.starter.OpenidProviderPropertiesResolver;
import com.c4_soft.springaddons.security.oidc.starter.properties.CorsProperties;
import com.c4_soft.springaddons.security.oidc.starter.properties.NotAConfiguredOpenidProviderException;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultAuthenticationManagerResolverCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultCorsFilterCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultJwtAbstractAuthenticationTokenConverterCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultOpaqueTokenAuthenticationConverterCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.IsIntrospectingResourceServerCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.IsJwtDecoderResourceServerCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.configuration.IsOidcResourceServerCondition;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.ServletConfigurationSupport;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.SpringAddonsOidcBeans;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.resourceserver.DefaultSpringAddonsJwtDecoderFactory;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.resourceserver.JwtAbstractAuthenticationTokenConverter;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.resourceserver.ResourceServerExpressionInterceptUrlRegistryPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.resourceserver.ResourceServerSynchronizedHttpSecurityPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.resourceserver.SpringAddonsJwtAuthenticationManagerResolver;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.resourceserver.SpringAddonsJwtDecoderFactory;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionAuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.web.filter.CorsFilter;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@Conditional(value={IsOidcResourceServerCondition.class})
@EnableWebSecurity
@AutoConfiguration
@ImportAutoConfiguration(value={SpringAddonsOidcBeans.class})
public class SpringAddonsOidcResourceServerBeans {
    @Conditional(value={IsJwtDecoderResourceServerCondition.class})
    @Order(value=0x7FFFFFFF)
    @Bean
    SecurityFilterChain springAddonsJwtResourceServerSecurityFilterChain(HttpSecurity http, ServerProperties serverProperties, SpringAddonsOidcProperties addonsProperties, ResourceServerExpressionInterceptUrlRegistryPostProcessor authorizePostProcessor, ResourceServerSynchronizedHttpSecurityPostProcessor httpPostProcessor, AuthenticationManagerResolver<HttpServletRequest> authenticationManagerResolver) throws Exception {
        http.oauth2ResourceServer(oauth2 -> oauth2.authenticationManagerResolver(authenticationManagerResolver));
        ServletConfigurationSupport.configureResourceServer(http, serverProperties, addonsProperties, authorizePostProcessor, httpPostProcessor);
        return (SecurityFilterChain)http.build();
    }

    @Conditional(value={IsIntrospectingResourceServerCondition.class})
    @Order(value=0x7FFFFFFF)
    @Bean
    SecurityFilterChain springAddonsIntrospectingResourceServerSecurityFilterChain(HttpSecurity http, ServerProperties serverProperties, SpringAddonsOidcProperties addonsProperties, ResourceServerExpressionInterceptUrlRegistryPostProcessor authorizePostProcessor, ResourceServerSynchronizedHttpSecurityPostProcessor httpPostProcessor, OpaqueTokenAuthenticationConverter introspectionAuthenticationConverter, OpaqueTokenIntrospector opaqueTokenIntrospector) throws Exception {
        http.oauth2ResourceServer(server -> server.opaqueToken(ot -> {
            ot.introspector(opaqueTokenIntrospector);
            ot.authenticationConverter(introspectionAuthenticationConverter);
        }));
        ServletConfigurationSupport.configureResourceServer(http, serverProperties, addonsProperties, authorizePostProcessor, httpPostProcessor);
        return (SecurityFilterChain)http.build();
    }

    @ConditionalOnMissingBean
    @Bean
    ResourceServerExpressionInterceptUrlRegistryPostProcessor authorizePostProcessor() {
        return registry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)registry.anyRequest()).authenticated();
    }

    @ConditionalOnMissingBean
    @Bean
    ResourceServerSynchronizedHttpSecurityPostProcessor httpPostProcessor() {
        return httpSecurity -> httpSecurity;
    }

    @ConditionalOnMissingBean
    @Bean
    SpringAddonsJwtDecoderFactory springAddonsJwtDecoderFactory() {
        return new DefaultSpringAddonsJwtDecoderFactory();
    }

    @Conditional(value={DefaultAuthenticationManagerResolverCondition.class})
    @Bean
    AuthenticationManagerResolver<HttpServletRequest> authenticationManagerResolver(OpenidProviderPropertiesResolver opPropertiesResolver, SpringAddonsJwtDecoderFactory jwtDecoderFactory, Converter<Jwt, AbstractAuthenticationToken> jwtAuthenticationConverter) {
        return new SpringAddonsJwtAuthenticationManagerResolver(opPropertiesResolver, jwtDecoderFactory, jwtAuthenticationConverter);
    }

    @Conditional(value={DefaultJwtAbstractAuthenticationTokenConverterCondition.class})
    @Bean
    JwtAbstractAuthenticationTokenConverter jwtAuthenticationConverter(Converter<Map<String, Object>, Collection<? extends GrantedAuthority>> authoritiesConverter, OpenidProviderPropertiesResolver opPropertiesResolver) {
        return jwt -> new JwtAuthenticationToken(jwt, (Collection)authoritiesConverter.convert((Object)jwt.getClaims()), new OpenidClaimSet(jwt.getClaims(), opPropertiesResolver.resolve(jwt.getClaims()).orElseThrow(() -> new NotAConfiguredOpenidProviderException(jwt.getClaims())).getUsernameClaim()).getName());
    }

    @Conditional(value={DefaultOpaqueTokenAuthenticationConverterCondition.class})
    @Bean
    OpaqueTokenAuthenticationConverter introspectionAuthenticationConverter(Converter<Map<String, Object>, Collection<? extends GrantedAuthority>> authoritiesConverter, SpringAddonsOidcProperties addonsProperties, OAuth2ResourceServerProperties resourceServerProperties) {
        return (introspectedToken, authenticatedPrincipal) -> {
            Object iatClaim = authenticatedPrincipal.getAttribute("iat");
            Object expClaim = authenticatedPrincipal.getAttribute("exp");
            return new BearerTokenAuthentication((OAuth2AuthenticatedPrincipal)new OAuth2IntrospectionAuthenticatedPrincipal(new OpenidClaimSet(authenticatedPrincipal.getAttributes(), addonsProperties.getOps().stream().filter(openidProvider -> resourceServerProperties.getOpaquetoken().getIntrospectionUri().contains(openidProvider.getIss().toString())).findAny().orElse(addonsProperties.getOps().get(0)).getUsernameClaim()).getName(), authenticatedPrincipal.getAttributes(), authenticatedPrincipal.getAuthorities()), new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, introspectedToken, SpringAddonsOidcResourceServerBeans.toInstant(iatClaim), SpringAddonsOidcResourceServerBeans.toInstant(expClaim)), (Collection)authoritiesConverter.convert((Object)authenticatedPrincipal.getAttributes()));
        };
    }

    @Conditional(value={DefaultCorsFilterCondition.class})
    @Bean
    CorsFilter corsFilter(SpringAddonsOidcProperties addonsProperties) {
        ArrayList<CorsProperties> corsProps = new ArrayList<CorsProperties>(addonsProperties.getCors());
        List<CorsProperties> deprecatedResourceServerCorsProps = addonsProperties.getResourceserver().getCors();
        corsProps.addAll(deprecatedResourceServerCorsProps);
        return ServletConfigurationSupport.getCorsFilterBean(corsProps);
    }

    private static final Instant toInstant(Object claim) {
        if (claim == null) {
            return null;
        }
        if (claim instanceof Instant) {
            Instant i = (Instant)claim;
            return i;
        }
        if (claim instanceof Date) {
            Date d = (Date)claim;
            return d.toInstant();
        }
        if (claim instanceof Integer) {
            Integer i = (Integer)claim;
            return Instant.ofEpochSecond(i.longValue());
        }
        if (claim instanceof Long) {
            Long l = (Long)claim;
            return Instant.ofEpochSecond(l);
        }
        return null;
    }
}

