/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive.client;

import com.c4_soft.springaddons.security.oidc.starter.AdditionalParamsAuthorizationRequestCustomizer;
import com.c4_soft.springaddons.security.oidc.starter.CompositeOAuth2AuthorizationRequestCustomizer;
import com.c4_soft.springaddons.security.oidc.starter.properties.InvalidRedirectionUriException;
import com.c4_soft.springaddons.security.oidc.starter.properties.MisconfiguredPostLoginUriException;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcClientProperties;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestCustomizers;
import org.springframework.security.oauth2.client.web.server.DefaultServerOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class SpringAddonsServerOAuth2AuthorizationRequestResolver
implements ServerOAuth2AuthorizationRequestResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringAddonsServerOAuth2AuthorizationRequestResolver.class);
    private static final Pattern authorizationRequestPattern = Pattern.compile("\\/oauth2\\/authorization\\/([^\\/]+)");
    private final URI clientUri;
    private final Map<String, CompositeOAuth2AuthorizationRequestCustomizer> requestCustomizers;
    private final ReactiveClientRegistrationRepository clientRegistrationRepository;
    private final ServerWebExchangeMatcher authorizationRequestMatcher;
    private final List<Pattern> postLoginAllowedUriPatterns;

    public SpringAddonsServerOAuth2AuthorizationRequestResolver(OAuth2ClientProperties bootClientProperties, ReactiveClientRegistrationRepository clientRegistrationRepository, SpringAddonsOidcClientProperties addonsClientProperties) {
        this.postLoginAllowedUriPatterns = addonsClientProperties.getPostLoginAllowedUriPatterns();
        String postLoginRedirectUriString = addonsClientProperties.getPostLoginRedirectUri().toString();
        if (this.postLoginAllowedUriPatterns.stream().noneMatch(p -> p.matcher(postLoginRedirectUriString).matches())) {
            throw new MisconfiguredPostLoginUriException(URI.create(postLoginRedirectUriString), this.postLoginAllowedUriPatterns);
        }
        this.clientUri = addonsClientProperties.getClientUri();
        this.authorizationRequestMatcher = new PathPatternParserServerWebExchangeMatcher("/oauth2/authorization/{registrationId}");
        this.requestCustomizers = bootClientProperties.getRegistration().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, registrationEntry -> {
            AdditionalParamsAuthorizationRequestCustomizer[] additionalParamsAuthorizationRequestCustomizerArray;
            MultiValueMap<String, String> additionalProperties = addonsClientProperties.getExtraAuthorizationParameters((String)registrationEntry.getKey());
            if (additionalProperties.size() > 0) {
                AdditionalParamsAuthorizationRequestCustomizer[] additionalParamsAuthorizationRequestCustomizerArray2 = new AdditionalParamsAuthorizationRequestCustomizer[1];
                additionalParamsAuthorizationRequestCustomizerArray = additionalParamsAuthorizationRequestCustomizerArray2;
                additionalParamsAuthorizationRequestCustomizerArray2[0] = new AdditionalParamsAuthorizationRequestCustomizer(additionalProperties);
            } else {
                additionalParamsAuthorizationRequestCustomizerArray = new AdditionalParamsAuthorizationRequestCustomizer[]{};
            }
            AdditionalParamsAuthorizationRequestCustomizer[] customizers = additionalParamsAuthorizationRequestCustomizerArray;
            CompositeOAuth2AuthorizationRequestCustomizer requestCustomizer = new CompositeOAuth2AuthorizationRequestCustomizer(customizers);
            if (addonsClientProperties.isPkceForced()) {
                requestCustomizer.addCustomizer(OAuth2AuthorizationRequestCustomizers.withPkce());
            }
            return requestCustomizer;
        }));
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    private Mono<WebSession> savePostLoginUrisInSession(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders headers = request.getHeaders();
        MultiValueMap params = request.getQueryParams();
        return exchange.getSession().map(session -> {
            Optional.ofNullable(Optional.ofNullable(headers.getFirst("X-POST-LOGIN-SUCCESS-URI")).orElse(Optional.ofNullable((String)params.getFirst((Object)"post_login_success_uri")).orElse(null))).filter(StringUtils::hasText).map(URI::create).ifPresent(postLoginSuccessUri -> {
                String postLoginSuccessUriString = postLoginSuccessUri.toString();
                if (this.postLoginAllowedUriPatterns.stream().noneMatch(p -> p.matcher(postLoginSuccessUriString).matches())) {
                    throw new InvalidRedirectionUriException((URI)postLoginSuccessUri);
                }
                session.getAttributes().put("post_login_success_uri", postLoginSuccessUri);
            });
            Optional.ofNullable(Optional.ofNullable(headers.getFirst("X-POST-LOGIN-FAILURE-URI")).orElse(Optional.ofNullable((String)params.getFirst((Object)"post_login_failure_uri")).orElse(null))).filter(StringUtils::hasText).map(URI::create).ifPresent(postLoginFailureUri -> {
                String postLoginFailureUriString = postLoginFailureUri.toString();
                if (this.postLoginAllowedUriPatterns.stream().noneMatch(p -> p.matcher(postLoginFailureUriString).matches())) {
                    throw new InvalidRedirectionUriException((URI)postLoginFailureUri);
                }
                session.getAttributes().put("post_login_failure_uri", postLoginFailureUri);
            });
            return session;
        });
    }

    private OAuth2AuthorizationRequest postProcess(OAuth2AuthorizationRequest request) {
        OAuth2AuthorizationRequest.Builder modified = OAuth2AuthorizationRequest.from((OAuth2AuthorizationRequest)request);
        URI original = URI.create(request.getRedirectUri());
        String redirectUri = UriComponentsBuilder.fromUri((URI)this.clientUri).path(original.getPath()).query(original.getQuery()).fragment(original.getFragment()).build().toString();
        modified.redirectUri(redirectUri);
        log.debug("Changed OAuth2AuthorizationRequest redirectUri from {} to {}", (Object)original, (Object)redirectUri);
        return modified.build();
    }

    public Mono<OAuth2AuthorizationRequest> resolve(ServerWebExchange exchange) {
        return this.authorizationRequestMatcher.matches(exchange).filter(matchResult -> matchResult.isMatch()).map(ServerWebExchangeMatcher.MatchResult::getVariables).map(variables -> variables.get("registrationId")).cast(String.class).flatMap(clientRegistrationId -> this.resolve(exchange, (String)clientRegistrationId));
    }

    public Mono<OAuth2AuthorizationRequest> resolve(ServerWebExchange exchange, String clientRegistrationId) {
        ServerOAuth2AuthorizationRequestResolver delegate = this.getRequestResolver(exchange, clientRegistrationId);
        return this.savePostLoginUrisInSession(exchange).then(delegate.resolve(exchange, clientRegistrationId).map(this::postProcess));
    }

    protected ServerOAuth2AuthorizationRequestResolver getRequestResolver(ServerWebExchange exchange, String clientRegistrationId) {
        Consumer<OAuth2AuthorizationRequest.Builder> requestCustomizer = this.getOAuth2AuthorizationRequestCustomizer(exchange, clientRegistrationId);
        if (requestCustomizer == null) {
            return null;
        }
        DefaultServerOAuth2AuthorizationRequestResolver delegate = new DefaultServerOAuth2AuthorizationRequestResolver(this.clientRegistrationRepository);
        delegate.setAuthorizationRequestCustomizer(requestCustomizer);
        return delegate;
    }

    protected Consumer<OAuth2AuthorizationRequest.Builder> getOAuth2AuthorizationRequestCustomizer(ServerWebExchange exchange, String clientRegistrationId) {
        return this.getCompositeOAuth2AuthorizationRequestCustomizer(clientRegistrationId);
    }

    protected CompositeOAuth2AuthorizationRequestCustomizer getCompositeOAuth2AuthorizationRequestCustomizer(String clientRegistrationId) {
        return this.requestCustomizers.get(clientRegistrationId);
    }

    static String resolveRegistrationId(ServerWebExchange exchange) {
        String requestPath = Optional.ofNullable(exchange.getRequest()).map(ServerHttpRequest::getPath).map(Object::toString).orElse("");
        return SpringAddonsServerOAuth2AuthorizationRequestResolver.resolveRegistrationId(requestPath);
    }

    static String resolveRegistrationId(String requestPath) {
        Matcher matcher = authorizationRequestPattern.matcher(requestPath);
        return matcher.matches() ? matcher.group(1) : null;
    }
}

