/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.synchronised.client;

import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.StreamSupport;
import org.springframework.security.oauth2.client.AuthorizationCodeOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.ClientCredentialsOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.DelegatingOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.JwtBearerOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.RefreshTokenOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.TokenExchangeOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.RestClientClientCredentialsTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.RestClientJwtBearerTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.RestClientRefreshTokenTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.RestClientTokenExchangeTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClient;

public final class PerRegistrationOAuth2AuthorizedClientProvider
implements OAuth2AuthorizedClientProvider {
    private final Map<String, OAuth2AuthorizedClientProvider> providersByRegistrationId = new ConcurrentHashMap<String, OAuth2AuthorizedClientProvider>();
    private final Map<String, List<OAuth2AuthorizedClientProvider>> customProvidersByRegistrationId;
    private final SpringAddonsOidcProperties addonsProperties;
    private final Map<String, RestClient> customTokenRestClientsByRegistrationId;

    public PerRegistrationOAuth2AuthorizedClientProvider(InMemoryClientRegistrationRepository clientRegistrationRepo, SpringAddonsOidcProperties addonsProperties, Map<String, RestClient> customTokenRestClientsByRegistrationId, Map<String, List<OAuth2AuthorizedClientProvider>> customProvidersByRegistrationId) {
        this.customProvidersByRegistrationId = new HashMap<String, List<OAuth2AuthorizedClientProvider>>(customProvidersByRegistrationId);
        this.addonsProperties = addonsProperties;
        this.customTokenRestClientsByRegistrationId = customTokenRestClientsByRegistrationId;
        StreamSupport.stream(clientRegistrationRepo.spliterator(), false).forEach(reg -> {
            DelegatingOAuth2AuthorizedClientProvider delegate = new DelegatingOAuth2AuthorizedClientProvider(this.getProvidersFor((ClientRegistration)reg, addonsProperties));
            this.providersByRegistrationId.put(reg.getRegistrationId(), (OAuth2AuthorizedClientProvider)delegate);
        });
    }

    public PerRegistrationOAuth2AuthorizedClientProvider(InMemoryClientRegistrationRepository clientRegistrationRepo, SpringAddonsOidcProperties addonsProperties, Map<String, RestClient> customTokenRestClientsByRegistrationId) {
        this(clientRegistrationRepo, addonsProperties, customTokenRestClientsByRegistrationId, Map.of());
    }

    public PerRegistrationOAuth2AuthorizedClientProvider(InMemoryClientRegistrationRepository clientRegistrationRepo, SpringAddonsOidcProperties addonsProperties) {
        this(clientRegistrationRepo, addonsProperties, Map.of(), Map.of());
    }

    public OAuth2AuthorizedClient authorize(OAuth2AuthorizationContext context) {
        if (context == null) {
            return null;
        }
        ClientRegistration registration = context.getClientRegistration();
        if (!this.providersByRegistrationId.containsKey(registration.getRegistrationId())) {
            DelegatingOAuth2AuthorizedClientProvider delegate = new DelegatingOAuth2AuthorizedClientProvider(this.getProvidersFor(registration, this.addonsProperties));
            this.providersByRegistrationId.put(registration.getRegistrationId(), (OAuth2AuthorizedClientProvider)delegate);
        }
        return this.providersByRegistrationId.get(registration.getRegistrationId()).authorize(context);
    }

    private List<OAuth2AuthorizedClientProvider> getProvidersFor(ClientRegistration registration, SpringAddonsOidcProperties addonsProperties) {
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)registration.getAuthorizationGrantType())) {
            return this.customProvidersByRegistrationId.computeIfAbsent(registration.getRegistrationId(), registrationId -> List.of(new AuthorizationCodeOAuth2AuthorizedClientProvider(), this.createRefreshTokenProvider(registration, addonsProperties)));
        }
        if (AuthorizationGrantType.CLIENT_CREDENTIALS.equals((Object)registration.getAuthorizationGrantType())) {
            return this.customProvidersByRegistrationId.computeIfAbsent(registration.getRegistrationId(), registrationId -> List.of(this.createClientCredentialsProvider(registration, addonsProperties)));
        }
        if (AuthorizationGrantType.TOKEN_EXCHANGE.equals((Object)registration.getAuthorizationGrantType())) {
            return this.customProvidersByRegistrationId.computeIfAbsent(registration.getRegistrationId(), registrationId -> List.of(this.createTokenExchangeProvider(registration, addonsProperties)));
        }
        if (AuthorizationGrantType.JWT_BEARER.equals((Object)registration.getAuthorizationGrantType())) {
            return this.customProvidersByRegistrationId.computeIfAbsent(registration.getRegistrationId(), registrationId -> List.of(this.createJwtBearerProvider(registration, addonsProperties)));
        }
        return List.of();
    }

    private ClientCredentialsOAuth2AuthorizedClientProvider createClientCredentialsProvider(ClientRegistration registration, SpringAddonsOidcProperties addonsProperties) {
        MultiValueMap<String, String> extraParameters;
        RestClientClientCredentialsTokenResponseClient responseClient = new RestClientClientCredentialsTokenResponseClient();
        ClientCredentialsOAuth2AuthorizedClientProvider provider = new ClientCredentialsOAuth2AuthorizedClientProvider();
        if (this.customTokenRestClientsByRegistrationId.containsKey(registration.getRegistrationId())) {
            responseClient.setRestClient(this.customTokenRestClientsByRegistrationId.get(registration.getRegistrationId()));
        }
        if ((extraParameters = addonsProperties.getClient().getExtraTokenParameters(registration.getRegistrationId())).size() > 0) {
            responseClient.setParametersCustomizer(parameters -> parameters.addAll(extraParameters));
        }
        provider.setAccessTokenResponseClient((OAuth2AccessTokenResponseClient)responseClient);
        return provider;
    }

    private RefreshTokenOAuth2AuthorizedClientProvider createRefreshTokenProvider(ClientRegistration registration, SpringAddonsOidcProperties addonsProperties) {
        MultiValueMap<String, String> extraParameters;
        RestClientRefreshTokenTokenResponseClient responseClient = new RestClientRefreshTokenTokenResponseClient();
        RefreshTokenOAuth2AuthorizedClientProvider provider = new RefreshTokenOAuth2AuthorizedClientProvider();
        if (this.customTokenRestClientsByRegistrationId.containsKey(registration.getRegistrationId())) {
            responseClient.setRestClient(this.customTokenRestClientsByRegistrationId.get(registration.getRegistrationId()));
        }
        if ((extraParameters = addonsProperties.getClient().getExtraTokenParameters(registration.getRegistrationId())).size() > 0) {
            responseClient.setParametersCustomizer(parameters -> parameters.addAll(extraParameters));
        }
        provider.setAccessTokenResponseClient((OAuth2AccessTokenResponseClient)responseClient);
        return provider;
    }

    private TokenExchangeOAuth2AuthorizedClientProvider createTokenExchangeProvider(ClientRegistration registration, SpringAddonsOidcProperties addonsProperties) {
        MultiValueMap<String, String> extraParameters;
        RestClientTokenExchangeTokenResponseClient responseClient = new RestClientTokenExchangeTokenResponseClient();
        TokenExchangeOAuth2AuthorizedClientProvider provider = new TokenExchangeOAuth2AuthorizedClientProvider();
        if (this.customTokenRestClientsByRegistrationId.containsKey(registration.getRegistrationId())) {
            responseClient.setRestClient(this.customTokenRestClientsByRegistrationId.get(registration.getRegistrationId()));
        }
        if ((extraParameters = addonsProperties.getClient().getExtraTokenParameters(registration.getRegistrationId())).size() > 0) {
            responseClient.setParametersCustomizer(parameters -> parameters.addAll(extraParameters));
        }
        provider.setAccessTokenResponseClient((OAuth2AccessTokenResponseClient)responseClient);
        return provider;
    }

    private JwtBearerOAuth2AuthorizedClientProvider createJwtBearerProvider(ClientRegistration registration, SpringAddonsOidcProperties addonsProperties) {
        MultiValueMap<String, String> extraParameters;
        RestClientJwtBearerTokenResponseClient responseClient = new RestClientJwtBearerTokenResponseClient();
        JwtBearerOAuth2AuthorizedClientProvider provider = new JwtBearerOAuth2AuthorizedClientProvider();
        if (this.customTokenRestClientsByRegistrationId.containsKey(registration.getRegistrationId())) {
            responseClient.setRestClient(this.customTokenRestClientsByRegistrationId.get(registration.getRegistrationId()));
        }
        if ((extraParameters = addonsProperties.getClient().getExtraTokenParameters(registration.getRegistrationId())).size() > 0) {
            responseClient.setParametersCustomizer(parameters -> parameters.addAll(extraParameters));
        }
        provider.setAccessTokenResponseClient((OAuth2AccessTokenResponseClient)responseClient);
        return provider;
    }
}

