/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.synchronised.client;

import com.c4_soft.springaddons.security.oidc.starter.AdditionalParamsAuthorizationRequestCustomizer;
import com.c4_soft.springaddons.security.oidc.starter.CompositeOAuth2AuthorizationRequestCustomizer;
import com.c4_soft.springaddons.security.oidc.starter.properties.InvalidRedirectionUriException;
import com.c4_soft.springaddons.security.oidc.starter.properties.MisconfiguredPostLoginUriException;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcClientProperties;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestCustomizers;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class SpringAddonsOAuth2AuthorizationRequestResolver
implements OAuth2AuthorizationRequestResolver {
    private static final String REGISTRATION_ID_URI_VARIABLE_NAME = "registrationId";
    private final URI clientUri;
    private final Map<String, CompositeOAuth2AuthorizationRequestCustomizer> requestCustomizers;
    private final ClientRegistrationRepository clientRegistrationRepository;
    private final AntPathRequestMatcher authorizationRequestMatcher = new AntPathRequestMatcher("/oauth2/authorization/{registrationId}");
    private final List<Pattern> postLoginAllowedUriPatterns;

    public SpringAddonsOAuth2AuthorizationRequestResolver(OAuth2ClientProperties bootClientProperties, ClientRegistrationRepository clientRegistrationRepository, SpringAddonsOidcClientProperties addonsClientProperties) {
        this.postLoginAllowedUriPatterns = addonsClientProperties.getPostLoginAllowedUriPatterns();
        String postLoginRedirectUriString = addonsClientProperties.getPostLoginRedirectUri().toString();
        if (this.postLoginAllowedUriPatterns.stream().noneMatch(p -> p.matcher(postLoginRedirectUriString).matches())) {
            throw new MisconfiguredPostLoginUriException(URI.create(postLoginRedirectUriString), this.postLoginAllowedUriPatterns);
        }
        this.clientUri = addonsClientProperties.getClientUri();
        this.requestCustomizers = bootClientProperties.getRegistration().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, registrationEntry -> {
            AdditionalParamsAuthorizationRequestCustomizer[] additionalParamsAuthorizationRequestCustomizerArray;
            MultiValueMap<String, String> additionalProperties = addonsClientProperties.getExtraAuthorizationParameters((String)registrationEntry.getKey());
            if (additionalProperties.size() > 0) {
                AdditionalParamsAuthorizationRequestCustomizer[] additionalParamsAuthorizationRequestCustomizerArray2 = new AdditionalParamsAuthorizationRequestCustomizer[1];
                additionalParamsAuthorizationRequestCustomizerArray = additionalParamsAuthorizationRequestCustomizerArray2;
                additionalParamsAuthorizationRequestCustomizerArray2[0] = new AdditionalParamsAuthorizationRequestCustomizer(additionalProperties);
            } else {
                additionalParamsAuthorizationRequestCustomizerArray = new AdditionalParamsAuthorizationRequestCustomizer[]{};
            }
            AdditionalParamsAuthorizationRequestCustomizer[] customizers = additionalParamsAuthorizationRequestCustomizerArray;
            CompositeOAuth2AuthorizationRequestCustomizer requestCustomizer = new CompositeOAuth2AuthorizationRequestCustomizer(customizers);
            if (addonsClientProperties.isPkceForced()) {
                requestCustomizer.addCustomizer(OAuth2AuthorizationRequestCustomizers.withPkce());
            }
            return requestCustomizer;
        }));
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    private Optional<String> getFirstParam(HttpServletRequest request, String paramName) {
        String[] values = request.getParameterValues(paramName);
        if (values == null || values.length < 1) {
            return Optional.empty();
        }
        return Optional.of(values[0]);
    }

    private void savePostLoginUrisInSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Optional.ofNullable(Optional.ofNullable(request.getHeader("X-POST-LOGIN-SUCCESS-URI")).orElse(this.getFirstParam(request, "post_login_success_uri").orElse(null))).filter(StringUtils::hasText).map(URI::create).ifPresent(postLoginSuccessUri -> {
            String postLoginSuccessUriString = postLoginSuccessUri.toString();
            if (this.postLoginAllowedUriPatterns.stream().noneMatch(p -> p.matcher(postLoginSuccessUriString).matches())) {
                throw new InvalidRedirectionUriException((URI)postLoginSuccessUri);
            }
            session.setAttribute("post_login_success_uri", postLoginSuccessUri);
        });
        Optional.ofNullable(Optional.ofNullable(request.getHeader("X-POST-LOGIN-FAILURE-URI")).orElse(this.getFirstParam(request, "post_login_failure_uri").orElse(null))).filter(StringUtils::hasText).map(URI::create).ifPresent(postLoginFailureUri -> {
            String postLoginFailureUriString = postLoginFailureUri.toString();
            if (this.postLoginAllowedUriPatterns.stream().noneMatch(p -> p.matcher(postLoginFailureUriString).matches())) {
                throw new InvalidRedirectionUriException((URI)postLoginFailureUri);
            }
            session.setAttribute("post_login_failure_uri", postLoginFailureUri);
        });
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request) {
        this.savePostLoginUrisInSession(request);
        String clientRegistrationId = this.resolveRegistrationId(request);
        OAuth2AuthorizationRequestResolver delegate = this.getRequestResolver(request, clientRegistrationId);
        if (delegate == null) {
            return null;
        }
        OAuth2AuthorizationRequest resolved = delegate.resolve(request);
        OAuth2AuthorizationRequest absolute = this.toAbsolute(resolved, request);
        return absolute;
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request, String clientRegistrationId) {
        this.savePostLoginUrisInSession(request);
        OAuth2AuthorizationRequestResolver delegate = this.getRequestResolver(request, clientRegistrationId);
        if (delegate == null) {
            return null;
        }
        OAuth2AuthorizationRequest resolved = delegate.resolve(request, clientRegistrationId);
        OAuth2AuthorizationRequest absolute = this.toAbsolute(resolved, request);
        return absolute;
    }

    protected OAuth2AuthorizationRequestResolver getRequestResolver(HttpServletRequest request, String clientRegistrationId) {
        Consumer<OAuth2AuthorizationRequest.Builder> requestCustomizer = this.getOAuth2AuthorizationRequestCustomizer(request, clientRegistrationId);
        if (requestCustomizer == null) {
            return null;
        }
        DefaultOAuth2AuthorizationRequestResolver delegate = new DefaultOAuth2AuthorizationRequestResolver(this.clientRegistrationRepository, "/oauth2/authorization");
        delegate.setAuthorizationRequestCustomizer(requestCustomizer);
        return delegate;
    }

    protected Consumer<OAuth2AuthorizationRequest.Builder> getOAuth2AuthorizationRequestCustomizer(HttpServletRequest request, String clientRegistrationId) {
        return this.getCompositeOAuth2AuthorizationRequestCustomizer(clientRegistrationId);
    }

    protected CompositeOAuth2AuthorizationRequestCustomizer getCompositeOAuth2AuthorizationRequestCustomizer(String clientRegistrationId) {
        return this.requestCustomizers.get(clientRegistrationId);
    }

    private OAuth2AuthorizationRequest toAbsolute(OAuth2AuthorizationRequest defaultAuthorizationRequest, HttpServletRequest request) {
        if (defaultAuthorizationRequest == null || this.clientUri == null) {
            return defaultAuthorizationRequest;
        }
        URI original = URI.create(defaultAuthorizationRequest.getRedirectUri());
        String redirectUri = UriComponentsBuilder.fromUri((URI)this.clientUri).path(original.getPath()).query(original.getQuery()).fragment(original.getFragment()).build().toString();
        return OAuth2AuthorizationRequest.from((OAuth2AuthorizationRequest)defaultAuthorizationRequest).redirectUri(redirectUri).build();
    }

    private String resolveRegistrationId(HttpServletRequest request) {
        if (this.authorizationRequestMatcher.matches(request)) {
            return (String)this.authorizationRequestMatcher.matcher(request).getVariables().get(REGISTRATION_ID_URI_VARIABLE_NAME);
        }
        return null;
    }
}

