/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.synchronised.client;

import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class SpringAddonsOauth2AuthenticationFailureHandler
implements AuthenticationFailureHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringAddonsOauth2AuthenticationFailureHandler.class);
    private final String redirectUri;
    private final HttpStatus postAuthorizationFailureStatus;

    public SpringAddonsOauth2AuthenticationFailureHandler(SpringAddonsOidcProperties addonsProperties) {
        this.redirectUri = addonsProperties.getClient().getLoginErrorRedirectPath().map(URI::toString).orElse("/");
        this.postAuthorizationFailureStatus = addonsProperties.getClient().getOauth2Redirections().getPostAuthorizationFailure();
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        String location = UriComponentsBuilder.fromUriString((String)Optional.ofNullable(request.getSession().getAttribute("post_login_failure_uri")).map(Object::toString).orElse(this.redirectUri)).queryParam("error", new Object[]{HtmlUtils.htmlEscape((String)exception.getMessage())}).build().toUri().toString();
        log.debug("Authentication failure. Status: {}, location: {}, message: {}", new Object[]{this.postAuthorizationFailureStatus.value(), location, exception.getMessage()});
        response.setStatus(this.postAuthorizationFailureStatus.value());
        response.setHeader("Location", location);
        response.setHeader("error", exception.getMessage());
        if (this.postAuthorizationFailureStatus.is4xxClientError() || this.postAuthorizationFailureStatus.is5xxServerError()) {
            response.getOutputStream().write(exception.getMessage().getBytes());
        }
        response.flushBuffer();
    }
}

