/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.synchronised.client;

import com.c4_soft.springaddons.security.oidc.starter.LogoutRequestUriBuilder;
import com.c4_soft.springaddons.security.oidc.starter.SpringAddonsOAuth2LogoutRequestUriBuilder;
import com.c4_soft.springaddons.security.oidc.starter.properties.CorsProperties;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultAuthenticationEntryPointCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultAuthenticationFailureHandlerCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultAuthenticationSuccessHandlerCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultCorsFilterCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultOidcBackChannelLogoutHandlerCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultOidcSessionRegistryCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.configuration.IsClientWithLoginCondition;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.ServletConfigurationSupport;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.SpringAddonsOidcBeans;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.ClientExpressionInterceptUrlRegistryPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.ClientSynchronizedHttpSecurityPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.PreAuthorizationCodeRedirectStrategy;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.SpringAddonsAuthenticationEntryPoint;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.SpringAddonsLogoutSuccessHandler;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.SpringAddonsOAuth2AuthorizationRequestResolver;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.SpringAddonsOauth2AuthenticationFailureHandler;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.SpringAddonsOauth2AuthenticationSuccessHandler;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.SpringAddonsOauth2RedirectStrategy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcBackChannelLogoutHandler;
import org.springframework.security.oauth2.client.oidc.session.InMemoryOidcSessionRegistry;
import org.springframework.security.oauth2.client.oidc.session.OidcSessionRegistry;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.util.UriComponentsBuilder;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@Conditional(value={IsClientWithLoginCondition.class})
@EnableWebSecurity
@AutoConfiguration
@ImportAutoConfiguration(value={SpringAddonsOidcBeans.class})
public class SpringAddonsOidcClientWithLoginBeans {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringAddonsOidcClientWithLoginBeans.class);

    @Order(value=0x7FFFFFFE)
    @Bean
    SecurityFilterChain springAddonsClientFilterChain(HttpSecurity http, ServerProperties serverProperties, PreAuthorizationCodeRedirectStrategy preAuthorizationCodeRedirectStrategy, OAuth2AuthorizationRequestResolver authorizationRequestResolver, AuthenticationEntryPoint authenticationEntryPoint, AuthenticationSuccessHandler authenticationSuccessHandler, AuthenticationFailureHandler authenticationFailureHandler, InvalidSessionStrategy invalidSessionStrategy, Optional<LogoutHandler> logoutHandler, LogoutSuccessHandler logoutSuccessHandler, SpringAddonsOidcProperties addonsProperties, ClientExpressionInterceptUrlRegistryPostProcessor authorizePostProcessor, ClientSynchronizedHttpSecurityPostProcessor httpPostProcessor, Optional<OidcBackChannelLogoutHandler> oidcBackChannelLogoutHandler) throws Exception {
        log.info("Applying client OAuth2 configuration for: {}", addonsProperties.getClient().getSecurityMatchers());
        http.securityMatcher(addonsProperties.getClient().getSecurityMatchers().toArray(new String[0]));
        http.sessionManagement(sessions -> sessions.invalidSessionStrategy(invalidSessionStrategy));
        http.exceptionHandling(exceptions -> exceptions.authenticationEntryPoint(authenticationEntryPoint));
        http.oauth2Login(login -> {
            login.authorizationEndpoint(authorizationEndpoint -> {
                authorizationEndpoint.authorizationRedirectStrategy((RedirectStrategy)preAuthorizationCodeRedirectStrategy);
                authorizationEndpoint.authorizationRequestResolver(authorizationRequestResolver);
            });
            login.successHandler(authenticationSuccessHandler);
            login.failureHandler(authenticationFailureHandler);
        });
        http.logout(logout -> logout.logoutSuccessHandler(logoutSuccessHandler));
        if (oidcBackChannelLogoutHandler.isPresent()) {
            http.oidcLogout(ol -> ol.backChannel(bc -> bc.logoutHandler((LogoutHandler)oidcBackChannelLogoutHandler.get())));
        }
        ServletConfigurationSupport.configureClient(http, serverProperties, addonsProperties, authorizePostProcessor, httpPostProcessor);
        return (SecurityFilterChain)http.build();
    }

    @ConditionalOnMissingBean
    @Bean
    OAuth2AuthorizationRequestResolver oAuth2AuthorizationRequestResolver(OAuth2ClientProperties bootClientProperties, ClientRegistrationRepository clientRegistrationRepository, SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsOAuth2AuthorizationRequestResolver(bootClientProperties, clientRegistrationRepository, addonsProperties.getClient());
    }

    @ConditionalOnMissingBean
    @Bean
    LogoutRequestUriBuilder logoutRequestUriBuilder(SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsOAuth2LogoutRequestUriBuilder(addonsProperties.getClient());
    }

    @ConditionalOnMissingBean
    @Bean
    LogoutSuccessHandler logoutSuccessHandler(LogoutRequestUriBuilder logoutRequestUriBuilder, ClientRegistrationRepository clientRegistrationRepository, SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsLogoutSuccessHandler(logoutRequestUriBuilder, clientRegistrationRepository, addonsProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    ClientExpressionInterceptUrlRegistryPostProcessor clientAuthorizePostProcessor() {
        return registry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)registry.anyRequest()).authenticated();
    }

    @ConditionalOnMissingBean
    @Bean
    ClientSynchronizedHttpSecurityPostProcessor clientHttpPostProcessor() {
        return http -> http;
    }

    @ConditionalOnMissingBean
    @Bean
    PreAuthorizationCodeRedirectStrategy authorizationCodeRedirectStrategy(SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsPreAuthorizationCodeRedirectStrategy(addonsProperties.getClient().getOauth2Redirections().getPreAuthorizationCode());
    }

    @ConditionalOnMissingBean(value={InvalidSessionStrategy.class})
    @Bean
    InvalidSessionStrategy invalidSessionStrategy(SpringAddonsOidcProperties addonsProperties) {
        return (request, response) -> {
            String location = addonsProperties.getClient().getInvalidSession().getLocation().map(URI::toString).orElseGet(() -> {
                URI requestUri = URI.create(request.getRequestURI());
                if (StringUtils.hasText((String)requestUri.getHost())) {
                    return requestUri.toString();
                }
                String[] segments = (String[])Arrays.stream(requestUri.getPath().split("/")).filter(StringUtils::hasText).toArray(String[]::new);
                return UriComponentsBuilder.fromUri((URI)addonsProperties.getClient().getClientUri()).pathSegment(segments).build().toString();
            });
            log.debug("Invalid session. Returning with status %d and %s as location".formatted(addonsProperties.getClient().getInvalidSession().getStatus().value(), location));
            response.setStatus(addonsProperties.getClient().getInvalidSession().getStatus().value());
            response.setHeader("Location", location);
            if (addonsProperties.getClient().getInvalidSession().getStatus().is4xxClientError() || addonsProperties.getClient().getInvalidSession().getStatus().is5xxServerError()) {
                response.getOutputStream().write("Invalid session. Please authenticate.".getBytes());
            }
            response.flushBuffer();
        };
    }

    @Conditional(value={DefaultAuthenticationEntryPointCondition.class})
    @Bean
    AuthenticationEntryPoint authenticationEntryPoint(SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsAuthenticationEntryPoint(addonsProperties.getClient());
    }

    @Conditional(value={DefaultAuthenticationSuccessHandlerCondition.class})
    @Bean
    AuthenticationSuccessHandler authenticationSuccessHandler(SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsOauth2AuthenticationSuccessHandler(addonsProperties);
    }

    @Conditional(value={DefaultAuthenticationFailureHandlerCondition.class})
    @Bean
    AuthenticationFailureHandler authenticationFailureHandler(SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsOauth2AuthenticationFailureHandler(addonsProperties);
    }

    @Conditional(value={DefaultCorsFilterCondition.class})
    @Bean
    CorsFilter corsFilter(SpringAddonsOidcProperties addonsProperties) {
        ArrayList<CorsProperties> corsProps = new ArrayList<CorsProperties>(addonsProperties.getCors());
        List<CorsProperties> deprecatedClientCorsProps = addonsProperties.getClient().getCors();
        corsProps.addAll(deprecatedClientCorsProps);
        return ServletConfigurationSupport.getCorsFilterBean(corsProps);
    }

    @Conditional(value={DefaultOidcSessionRegistryCondition.class})
    @Bean
    OidcSessionRegistry oidcSessionRegistry() {
        return new InMemoryOidcSessionRegistry();
    }

    @Conditional(value={DefaultOidcBackChannelLogoutHandlerCondition.class})
    @Bean
    OidcBackChannelLogoutHandler oidcBackChannelLogoutHandler(OidcSessionRegistry sessionRegistry, SpringAddonsOidcProperties addonsProperties) {
        OidcBackChannelLogoutHandler logoutHandler = new OidcBackChannelLogoutHandler(sessionRegistry);
        addonsProperties.getClient().getBackChannelLogout().getInternalLogoutUri().ifPresent(arg_0 -> ((OidcBackChannelLogoutHandler)logoutHandler).setLogoutUri(arg_0));
        addonsProperties.getClient().getBackChannelLogout().getCookieName().ifPresent(arg_0 -> ((OidcBackChannelLogoutHandler)logoutHandler).setSessionCookieName(arg_0));
        return logoutHandler;
    }

    public static class SpringAddonsPreAuthorizationCodeRedirectStrategy
    extends SpringAddonsOauth2RedirectStrategy
    implements PreAuthorizationCodeRedirectStrategy {
        public SpringAddonsPreAuthorizationCodeRedirectStrategy(HttpStatus defaultStatus) {
            super(defaultStatus);
        }
    }
}

