/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter;

import com.c4_soft.springaddons.security.oidc.starter.ClaimSetAuthoritiesConverter;
import com.c4_soft.springaddons.security.oidc.starter.OpenidProviderPropertiesResolver;
import com.c4_soft.springaddons.security.oidc.starter.properties.NotAConfiguredOpenidProviderException;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.StringUtils;

public class ConfigurableClaimSetAuthoritiesConverter
implements ClaimSetAuthoritiesConverter {
    private final OpenidProviderPropertiesResolver opPropertiesResolver;

    public Collection<? extends GrantedAuthority> convert(@NonNull Map<String, Object> source) {
        SpringAddonsOidcProperties.OpenidProviderProperties opProperties = this.opPropertiesResolver.resolve(source).orElseThrow(() -> new NotAConfiguredOpenidProviderException(source));
        return opProperties.getAuthorities().stream().flatMap(authoritiesMappingProps -> ConfigurableClaimSetAuthoritiesConverter.getAuthorities(source, authoritiesMappingProps)).map(r -> new SimpleGrantedAuthority(r)).toList();
    }

    private static String processCase(String role, SpringAddonsOidcProperties.OpenidProviderProperties.SimpleAuthoritiesMappingProperties.Case caze) {
        switch (caze) {
            case UPPER: {
                return role.toUpperCase();
            }
            case LOWER: {
                return role.toLowerCase();
            }
        }
        return role;
    }

    private static Stream<String> getAuthorities(Map<String, Object> claims, SpringAddonsOidcProperties.OpenidProviderProperties.SimpleAuthoritiesMappingProperties props) {
        return ConfigurableClaimSetAuthoritiesConverter.getClaims(claims, props.getPath()).filter(StringUtils::hasText).map(String::trim).map(r -> ConfigurableClaimSetAuthoritiesConverter.processCase(r, props.getCaze())).map(r -> String.format("%s%s", props.getPrefix(), r));
    }

    private static Stream<String> getClaims(Map<String, Object> claims, String path) {
        try {
            Object res = JsonPath.read(claims, (String)path, (Predicate[])new Predicate[0]);
            if (res instanceof String) {
                String r = (String)res;
                return Stream.of(r).flatMap(claim -> Stream.of(claim.split(","))).flatMap(claim -> Stream.of(claim.split(" ")));
            }
            if (res instanceof List) {
                List l = (List)res;
                if (l.size() == 0) {
                    return Stream.empty();
                }
                if (l.get(0) instanceof String) {
                    return l.stream();
                }
                if (l.get(0) instanceof List) {
                    return l.stream().flatMap(o -> ((List)o).stream());
                }
            }
            return Stream.empty();
        }
        catch (PathNotFoundException e) {
            return Stream.empty();
        }
    }

    @Generated
    public ConfigurableClaimSetAuthoritiesConverter(OpenidProviderPropertiesResolver opPropertiesResolver) {
        this.opPropertiesResolver = opPropertiesResolver;
    }
}

