/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive;

import com.c4_soft.springaddons.security.oidc.starter.properties.CorsProperties;
import com.c4_soft.springaddons.security.oidc.starter.properties.Csrf;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.ClientAuthorizeExchangeSpecPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.ClientReactiveHttpSecurityPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.reactive.resourceserver.ResourceServerAuthorizeExchangeSpecPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.reactive.resourceserver.ResourceServerReactiveHttpSecurityPostProcessor;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.server.context.NoOpServerSecurityContextRepository;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.security.web.server.csrf.CookieServerCsrfTokenRepository;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRepository;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRequestAttributeHandler;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRequestHandler;
import org.springframework.security.web.server.csrf.XorServerCsrfTokenRequestAttributeHandler;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.cors.reactive.CorsWebFilter;
import org.springframework.web.cors.reactive.UrlBasedCorsConfigurationSource;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ReactiveConfigurationSupport {
    public static ServerHttpSecurity configureResourceServer(ServerHttpSecurity http, ServerProperties serverProperties, SpringAddonsOidcProperties addonsProperties, ResourceServerAuthorizeExchangeSpecPostProcessor authorizePostProcessor, ResourceServerReactiveHttpSecurityPostProcessor httpPostProcessor) {
        http.exceptionHandling(exceptions -> {
            String issuers = addonsProperties.getOps().stream().map(SpringAddonsOidcProperties.OpenidProviderProperties::getIss).filter(iss -> iss != null).map(URI::toString).collect(Collectors.joining(",", "\"", "\""));
            exceptions.authenticationEntryPoint((exchange, ex) -> {
                ServerHttpResponse response = exchange.getResponse();
                response.setStatusCode((HttpStatusCode)HttpStatus.UNAUTHORIZED);
                response.getHeaders().set("WWW-Authenticate", "OAuth realm=%s".formatted(issuers));
                DataBufferFactory dataBufferFactory = response.bufferFactory();
                DataBuffer buffer = dataBufferFactory.wrap(ex.getMessage().getBytes(Charset.defaultCharset()));
                return response.writeWith((Publisher)Mono.just((Object)buffer)).doOnError(error -> DataBufferUtils.release((DataBuffer)buffer));
            });
        });
        ReactiveConfigurationSupport.configureState(http, addonsProperties.getResourceserver().isStatlessSessions(), addonsProperties.getResourceserver().getCsrf(), addonsProperties.getResourceserver().getCsrfCookieName(), addonsProperties.getResourceserver().getCsrfCookiePath());
        ArrayList<CorsProperties> corsProps = new ArrayList<CorsProperties>(addonsProperties.getCors());
        List<CorsProperties> deprecatedClientCorsProps = addonsProperties.getClient().getCors();
        List<CorsProperties> deprecatedResourceServerCorsProps = addonsProperties.getResourceserver().getCors();
        corsProps.addAll(deprecatedClientCorsProps);
        corsProps.addAll(deprecatedResourceServerCorsProps);
        ReactiveConfigurationSupport.configureAccess(http, addonsProperties.getResourceserver().getPermitAll(), corsProps);
        if (serverProperties.getSsl() != null && serverProperties.getSsl().isEnabled()) {
            http.redirectToHttps(Customizer.withDefaults());
        }
        http.authorizeExchange(registry -> authorizePostProcessor.authorizeHttpRequests((ServerHttpSecurity.AuthorizeExchangeSpec)registry));
        httpPostProcessor.process(http);
        return http;
    }

    public static ServerHttpSecurity configureClient(ServerHttpSecurity http, ServerProperties serverProperties, SpringAddonsOidcProperties addonsProperties, ClientAuthorizeExchangeSpecPostProcessor authorizePostProcessor, ClientReactiveHttpSecurityPostProcessor httpPostProcessor) {
        ReactiveConfigurationSupport.configureState(http, false, addonsProperties.getClient().getCsrf(), addonsProperties.getClient().getCsrfCookieName(), addonsProperties.getClient().getCsrfCookiePath());
        ArrayList<CorsProperties> corsProps = new ArrayList<CorsProperties>(addonsProperties.getCors());
        List<CorsProperties> deprecatedClientCorsProps = addonsProperties.getClient().getCors();
        List<CorsProperties> deprecatedResourceServerCorsProps = addonsProperties.getResourceserver().getCors();
        corsProps.addAll(deprecatedClientCorsProps);
        corsProps.addAll(deprecatedResourceServerCorsProps);
        ReactiveConfigurationSupport.configureAccess(http, addonsProperties.getClient().getPermitAll(), corsProps);
        if (serverProperties.getSsl() != null && serverProperties.getSsl().isEnabled()) {
            http.redirectToHttps(Customizer.withDefaults());
        }
        http.authorizeExchange(registry -> authorizePostProcessor.authorizeHttpRequests((ServerHttpSecurity.AuthorizeExchangeSpec)registry));
        httpPostProcessor.process(http);
        return http;
    }

    public static ServerHttpSecurity configureAccess(ServerHttpSecurity http, List<String> permitAll, List<CorsProperties> corsProperties) {
        List<String> permittedCorsOptions = corsProperties.stream().filter(cors -> (cors.getAllowedMethods().contains("*") || cors.getAllowedMethods().contains("OPTIONS")) && !cors.isDisableAnonymousOptions()).map(CorsProperties::getPath).toList();
        if (permitAll.size() > 0 || permittedCorsOptions.size() > 0) {
            http.anonymous(Customizer.withDefaults());
        }
        if (permitAll.size() > 0) {
            http.authorizeExchange(authorizeExchange -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorizeExchange.pathMatchers(permitAll.toArray(new String[0]))).permitAll());
        }
        if (permittedCorsOptions.size() > 0) {
            http.authorizeExchange(authorizeExchange -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorizeExchange.pathMatchers(HttpMethod.OPTIONS, permittedCorsOptions.toArray(new String[0]))).permitAll());
        }
        return http;
    }

    public static CorsWebFilter getCorsFilterBean(List<CorsProperties> corsProperties) {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        for (CorsProperties corsProps : corsProperties) {
            CorsConfiguration configuration = new CorsConfiguration();
            configuration.setAllowCredentials(corsProps.getAllowCredentials());
            configuration.setAllowedHeaders(corsProps.getAllowedHeaders());
            configuration.setAllowedMethods(corsProps.getAllowedMethods());
            configuration.setAllowedOriginPatterns(corsProps.getAllowedOriginPatterns());
            configuration.setExposedHeaders(corsProps.getExposedHeaders());
            configuration.setMaxAge(corsProps.getMaxAge());
            source.registerCorsConfiguration(corsProps.getPath(), configuration);
        }
        return new CorsWebFilter((CorsConfigurationSource)source);
    }

    public static ServerHttpSecurity configureState(ServerHttpSecurity http, boolean isStatless, Csrf csrfEnum, String csrfCookieName, String csrfCookiePath) {
        if (isStatless) {
            http.securityContextRepository((ServerSecurityContextRepository)NoOpServerSecurityContextRepository.getInstance());
        }
        http.csrf(csrf -> {
            switch (csrfEnum) {
                case DISABLE: {
                    csrf.disable();
                    break;
                }
                case DEFAULT: {
                    if (isStatless) {
                        csrf.disable();
                        break;
                    }
                    Customizer.withDefaults();
                    break;
                }
                case SESSION: {
                    Customizer.withDefaults();
                    break;
                }
                case COOKIE_ACCESSIBLE_FROM_JS: {
                    CookieServerCsrfTokenRepository repo = CookieServerCsrfTokenRepository.withHttpOnlyFalse();
                    repo.setCookiePath(csrfCookiePath);
                    repo.setCookieName(csrfCookieName);
                    csrf.csrfTokenRepository((ServerCsrfTokenRepository)repo).csrfTokenRequestHandler((ServerCsrfTokenRequestHandler)new SpaCsrfTokenRequestHandler());
                }
            }
        });
        return http;
    }

    static final class SpaCsrfTokenRequestHandler
    extends ServerCsrfTokenRequestAttributeHandler {
        private final ServerCsrfTokenRequestAttributeHandler delegate = new XorServerCsrfTokenRequestAttributeHandler();

        SpaCsrfTokenRequestHandler() {
        }

        public void handle(ServerWebExchange exchange, Mono<CsrfToken> csrfToken) {
            this.delegate.handle(exchange, csrfToken);
        }

        public Mono<String> resolveCsrfTokenValue(ServerWebExchange exchange, CsrfToken csrfToken) {
            return Mono.justOrEmpty((Object)exchange.getRequest().getHeaders().getFirst(csrfToken.getHeaderName())).switchIfEmpty(this.delegate.resolveCsrfTokenValue(exchange, csrfToken));
        }
    }
}

