/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive.client;

import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.StreamSupport;
import org.springframework.security.oauth2.client.AuthorizationCodeReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.ClientCredentialsReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.DelegatingReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.JwtBearerReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.RefreshTokenReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.TokenExchangeReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.WebClientReactiveClientCredentialsTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.WebClientReactiveJwtBearerTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.WebClientReactiveRefreshTokenTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.WebClientReactiveTokenExchangeTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.InMemoryReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public final class PerRegistrationReactiveOAuth2AuthorizedClientProvider
implements ReactiveOAuth2AuthorizedClientProvider {
    private final Map<String, DelegatingReactiveOAuth2AuthorizedClientProvider> providersByRegistrationId = new ConcurrentHashMap<String, DelegatingReactiveOAuth2AuthorizedClientProvider>();
    private final Map<String, List<ReactiveOAuth2AuthorizedClientProvider>> customProvidersByRegistrationId;
    private final SpringAddonsOidcProperties addonsProperties;
    private final Map<String, WebClient> customTokenRestClientsByRegistrationId;

    public PerRegistrationReactiveOAuth2AuthorizedClientProvider(InMemoryReactiveClientRegistrationRepository clientRegistrationRepo, SpringAddonsOidcProperties addonsProperties, Map<String, WebClient> customTokenRestClientsByRegistrationId, Map<String, List<ReactiveOAuth2AuthorizedClientProvider>> customProvidersByRegistrationId) {
        this.customTokenRestClientsByRegistrationId = customTokenRestClientsByRegistrationId;
        this.customProvidersByRegistrationId = new HashMap<String, List<ReactiveOAuth2AuthorizedClientProvider>>(customProvidersByRegistrationId);
        this.addonsProperties = addonsProperties;
        StreamSupport.stream(clientRegistrationRepo.spliterator(), false).forEach(reg -> {
            DelegatingReactiveOAuth2AuthorizedClientProvider delegate = new DelegatingReactiveOAuth2AuthorizedClientProvider(this.getProvidersFor((ClientRegistration)reg, addonsProperties));
            this.providersByRegistrationId.put(reg.getRegistrationId(), delegate);
        });
    }

    public PerRegistrationReactiveOAuth2AuthorizedClientProvider(InMemoryReactiveClientRegistrationRepository clientRegistrationRepo, SpringAddonsOidcProperties addonsProperties, Map<String, WebClient> customTokenRestClientsByRegistrationId) {
        this(clientRegistrationRepo, addonsProperties, customTokenRestClientsByRegistrationId, Map.of());
    }

    public PerRegistrationReactiveOAuth2AuthorizedClientProvider(InMemoryReactiveClientRegistrationRepository clientRegistrationRepo, SpringAddonsOidcProperties addonsProperties) {
        this(clientRegistrationRepo, addonsProperties, Map.of(), Map.of());
    }

    public Mono<OAuth2AuthorizedClient> authorize(OAuth2AuthorizationContext context) {
        if (context == null) {
            return null;
        }
        ClientRegistration registration = context.getClientRegistration();
        if (!this.providersByRegistrationId.containsKey(registration.getRegistrationId())) {
            DelegatingReactiveOAuth2AuthorizedClientProvider delegate = new DelegatingReactiveOAuth2AuthorizedClientProvider(this.getProvidersFor(registration, this.addonsProperties));
            this.providersByRegistrationId.put(registration.getRegistrationId(), delegate);
        }
        return this.providersByRegistrationId.get(registration.getRegistrationId()).authorize(context);
    }

    private List<ReactiveOAuth2AuthorizedClientProvider> getProvidersFor(ClientRegistration registration, SpringAddonsOidcProperties addonsProperties) {
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)registration.getAuthorizationGrantType())) {
            return this.customProvidersByRegistrationId.computeIfAbsent(registration.getRegistrationId(), registrationId -> List.of(new AuthorizationCodeReactiveOAuth2AuthorizedClientProvider(), this.createRefreshTokenProvider(registration, addonsProperties)));
        }
        if (AuthorizationGrantType.CLIENT_CREDENTIALS.equals((Object)registration.getAuthorizationGrantType())) {
            return this.customProvidersByRegistrationId.computeIfAbsent(registration.getRegistrationId(), registrationId -> List.of(this.createClientCredentialsProvider(registration, addonsProperties)));
        }
        if (AuthorizationGrantType.TOKEN_EXCHANGE.equals((Object)registration.getAuthorizationGrantType())) {
            return this.customProvidersByRegistrationId.computeIfAbsent(registration.getRegistrationId(), registrationId -> List.of(this.createTokenExchangeProvider(registration, addonsProperties)));
        }
        if (AuthorizationGrantType.JWT_BEARER.equals((Object)registration.getAuthorizationGrantType())) {
            return this.customProvidersByRegistrationId.computeIfAbsent(registration.getRegistrationId(), registrationId -> List.of(this.createJwtBearerProvider(registration, addonsProperties)));
        }
        return List.of();
    }

    private ClientCredentialsReactiveOAuth2AuthorizedClientProvider createClientCredentialsProvider(ClientRegistration registration, SpringAddonsOidcProperties addonsProperties) {
        MultiValueMap<String, String> extraParameters;
        ClientCredentialsReactiveOAuth2AuthorizedClientProvider provider = new ClientCredentialsReactiveOAuth2AuthorizedClientProvider();
        WebClientReactiveClientCredentialsTokenResponseClient responseClient = new WebClientReactiveClientCredentialsTokenResponseClient();
        if (this.customTokenRestClientsByRegistrationId.containsKey(registration.getRegistrationId())) {
            responseClient.setWebClient(this.customTokenRestClientsByRegistrationId.get(registration.getRegistrationId()));
        }
        if ((extraParameters = addonsProperties.getClient().getExtraTokenParameters(registration.getRegistrationId())).size() > 0) {
            responseClient.setParametersCustomizer(parameters -> parameters.addAll(extraParameters));
        }
        provider.setAccessTokenResponseClient((ReactiveOAuth2AccessTokenResponseClient)responseClient);
        return provider;
    }

    private RefreshTokenReactiveOAuth2AuthorizedClientProvider createRefreshTokenProvider(ClientRegistration registration, SpringAddonsOidcProperties addonsProperties) {
        MultiValueMap<String, String> extraParameters;
        RefreshTokenReactiveOAuth2AuthorizedClientProvider provider = new RefreshTokenReactiveOAuth2AuthorizedClientProvider();
        WebClientReactiveRefreshTokenTokenResponseClient responseClient = new WebClientReactiveRefreshTokenTokenResponseClient();
        if (this.customTokenRestClientsByRegistrationId.containsKey(registration.getRegistrationId())) {
            responseClient.setWebClient(this.customTokenRestClientsByRegistrationId.get(registration.getRegistrationId()));
        }
        if ((extraParameters = addonsProperties.getClient().getExtraTokenParameters(registration.getRegistrationId())).size() > 0) {
            responseClient.setParametersCustomizer(parameters -> parameters.addAll(extraParameters));
        }
        provider.setAccessTokenResponseClient((ReactiveOAuth2AccessTokenResponseClient)responseClient);
        return provider;
    }

    private TokenExchangeReactiveOAuth2AuthorizedClientProvider createTokenExchangeProvider(ClientRegistration registration, SpringAddonsOidcProperties addonsProperties) {
        MultiValueMap<String, String> extraParameters;
        TokenExchangeReactiveOAuth2AuthorizedClientProvider provider = new TokenExchangeReactiveOAuth2AuthorizedClientProvider();
        WebClientReactiveTokenExchangeTokenResponseClient responseClient = new WebClientReactiveTokenExchangeTokenResponseClient();
        if (this.customTokenRestClientsByRegistrationId.containsKey(registration.getRegistrationId())) {
            responseClient.setWebClient(this.customTokenRestClientsByRegistrationId.get(registration.getRegistrationId()));
        }
        if ((extraParameters = addonsProperties.getClient().getExtraTokenParameters(registration.getRegistrationId())).size() > 0) {
            responseClient.setParametersCustomizer(parameters -> parameters.addAll(extraParameters));
        }
        provider.setAccessTokenResponseClient((ReactiveOAuth2AccessTokenResponseClient)responseClient);
        return provider;
    }

    private JwtBearerReactiveOAuth2AuthorizedClientProvider createJwtBearerProvider(ClientRegistration registration, SpringAddonsOidcProperties addonsProperties) {
        MultiValueMap<String, String> extraParameters;
        JwtBearerReactiveOAuth2AuthorizedClientProvider provider = new JwtBearerReactiveOAuth2AuthorizedClientProvider();
        WebClientReactiveJwtBearerTokenResponseClient responseClient = new WebClientReactiveJwtBearerTokenResponseClient();
        if (this.customTokenRestClientsByRegistrationId.containsKey(registration.getRegistrationId())) {
            responseClient.setWebClient(this.customTokenRestClientsByRegistrationId.get(registration.getRegistrationId()));
        }
        if ((extraParameters = addonsProperties.getClient().getExtraTokenParameters(registration.getRegistrationId())).size() > 0) {
            responseClient.setParametersCustomizer(parameters -> parameters.addAll(extraParameters));
        }
        provider.setAccessTokenResponseClient((ReactiveOAuth2AccessTokenResponseClient)responseClient);
        return provider;
    }
}

