/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.synchronised;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpServletRequestSupport {
    public static Optional<HttpServletRequest> getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            ServletRequestAttributes attr = (ServletRequestAttributes)requestAttributes;
            return Optional.ofNullable(attr.getRequest());
        }
        return Optional.empty();
    }

    public static Optional<HttpSession> getSession() {
        return HttpServletRequestSupport.getRequest().flatMap(req -> Optional.ofNullable(req.getSession()));
    }

    public static Object getSessionAttribute(String name) {
        return HttpServletRequestSupport.getSession().map(session -> session.getAttribute(name)).orElse(null);
    }

    public static void setSessionAttribute(String name, Object value) {
        HttpServletRequestSupport.getSession().ifPresent(session -> session.setAttribute(name, value));
    }

    public static String getUniqueRequestHeader(String headerName) throws MissingHeaderException, MultiValuedHeaderException {
        List<String> headers = HttpServletRequestSupport.getNonEmptyRequestHeaderValues(headerName);
        if (headers.size() < 1) {
            throw new MissingHeaderException(headerName);
        }
        if (headers.size() > 1) {
            throw new MultiValuedHeaderException(headerName);
        }
        return headers.get(0);
    }

    public static List<String> getNonEmptyRequestHeaderValues(String headerName) {
        return HttpServletRequestSupport.getRequest().map(req -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(req.getHeaders(headerName).asIterator(), 16), false).filter(StringUtils::hasLength).toList()).orElse(List.of());
    }

    @ResponseStatus(code=HttpStatus.UNAUTHORIZED)
    public static class MissingHeaderException
    extends RuntimeException {
        private static final long serialVersionUID = -4894061353773464761L;

        public MissingHeaderException(String headerName) {
            super(headerName + " is missing");
            assert (StringUtils.hasText((String)headerName));
        }
    }

    @ResponseStatus(code=HttpStatus.UNAUTHORIZED)
    public static class MultiValuedHeaderException
    extends RuntimeException {
        private static final long serialVersionUID = 1654993007508549674L;

        public MultiValuedHeaderException(String headerName) {
            super(headerName + " is not unique");
            assert (StringUtils.hasText((String)headerName));
        }
    }

    @ResponseStatus(code=HttpStatus.UNAUTHORIZED)
    public static class InvalidHeaderException
    extends RuntimeException {
        private static final long serialVersionUID = -6233252290377524340L;

        public InvalidHeaderException(String headerName) {
            super(headerName + " is not valid");
            assert (StringUtils.hasText((String)headerName));
        }
    }
}

