/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive.client;

import com.c4_soft.springaddons.security.oidc.starter.LogoutRequestUriBuilder;
import com.c4_soft.springaddons.security.oidc.starter.properties.InvalidRedirectionUriException;
import com.c4_soft.springaddons.security.oidc.starter.properties.MisconfiguredPostLogoutUriException;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.SpringAddonsOauth2ServerRedirectStrategy;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class SpringAddonsServerLogoutSuccessHandler
implements ServerLogoutSuccessHandler {
    private final LogoutRequestUriBuilder uriBuilder;
    private final ReactiveClientRegistrationRepository clientRegistrationRepo;
    private final ServerRedirectStrategy redirectStrategy;
    private final String defaultPostLogoutUri;
    private final List<Pattern> postLogoutAllowedUriPatterns;

    public SpringAddonsServerLogoutSuccessHandler(LogoutRequestUriBuilder uriBuilder, ReactiveClientRegistrationRepository clientRegistrationRepo, SpringAddonsOidcProperties addonsProperties) {
        this.postLogoutAllowedUriPatterns = addonsProperties.getClient().getPostLogoutAllowedUriPatterns();
        this.defaultPostLogoutUri = Optional.ofNullable(addonsProperties.getClient().getPostLogoutRedirectUri()).map(URI::toString).orElse(null);
        if (this.postLogoutAllowedUriPatterns.stream().noneMatch(p -> p.matcher(this.defaultPostLogoutUri).matches())) {
            throw new MisconfiguredPostLogoutUriException(URI.create(this.defaultPostLogoutUri), this.postLogoutAllowedUriPatterns);
        }
        this.uriBuilder = uriBuilder;
        this.clientRegistrationRepo = clientRegistrationRepo;
        this.redirectStrategy = new SpringAddonsOauth2ServerRedirectStrategy(addonsProperties.getClient().getOauth2Redirections().getRpInitiatedLogout());
    }

    public Mono<Void> onLogoutSuccess(WebFilterExchange exchange, Authentication authentication) {
        if (authentication instanceof OAuth2AuthenticationToken) {
            OAuth2AuthenticationToken oauth = (OAuth2AuthenticationToken)authentication;
            String postLogoutUri = Optional.ofNullable(exchange.getExchange().getRequest().getHeaders().getFirst("X-POST-LOGOUT-SUCCESS-URI")).orElse(Optional.ofNullable((String)exchange.getExchange().getRequest().getQueryParams().getFirst((Object)"post_logout_success_uri")).orElse(this.defaultPostLogoutUri));
            if (this.postLogoutAllowedUriPatterns.stream().noneMatch(p -> p.matcher(postLogoutUri).matches())) {
                throw new InvalidRedirectionUriException(URI.create(postLogoutUri));
            }
            return this.clientRegistrationRepo.findByRegistrationId(oauth.getAuthorizedClientRegistrationId()).flatMap(client -> {
                if (StringUtils.hasText((String)postLogoutUri)) {
                    return Mono.justOrEmpty(this.uriBuilder.getLogoutRequestUri((ClientRegistration)client, ((OidcUser)oauth.getPrincipal()).getIdToken().getTokenValue(), Optional.of(URI.create(postLogoutUri))));
                }
                return Mono.justOrEmpty(this.uriBuilder.getLogoutRequestUri((ClientRegistration)client, ((OidcUser)oauth.getPrincipal()).getIdToken().getTokenValue()));
            }).flatMap(logoutUri -> this.redirectStrategy.sendRedirect(exchange.getExchange(), URI.create(logoutUri)));
        }
        return Mono.empty().then();
    }
}

