/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive.client;

import com.c4_soft.springaddons.security.oidc.starter.LogoutRequestUriBuilder;
import com.c4_soft.springaddons.security.oidc.starter.SpringAddonsOAuth2LogoutRequestUriBuilder;
import com.c4_soft.springaddons.security.oidc.starter.properties.CorsProperties;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.CookieCsrfCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultAuthenticationEntryPointCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultAuthenticationFailureHandlerCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultAuthenticationSuccessHandlerCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultCorsWebFilterCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultOidcBackChannelLogoutHandlerCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultOidcSessionRegistryCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.configuration.IsClientWithLoginCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.configuration.IsNotServlet;
import com.c4_soft.springaddons.security.oidc.starter.reactive.ReactiveConfigurationSupport;
import com.c4_soft.springaddons.security.oidc.starter.reactive.ReactiveSpringAddonsOidcBeans;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.ClientAuthorizeExchangeSpecPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.ClientReactiveHttpSecurityPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.SpringAddonsOauth2ServerAuthenticationFailureHandler;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.SpringAddonsOauth2ServerAuthenticationSuccessHandler;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.SpringAddonsOauth2ServerRedirectStrategy;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.SpringAddonsServerAuthenticationEntryPoint;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.SpringAddonsServerLogoutSuccessHandler;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.SpringAddonsServerOAuth2AuthorizationRequestResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.OidcBackChannelServerLogoutHandler;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.oauth2.client.oidc.server.session.InMemoryReactiveOidcSessionRegistry;
import org.springframework.security.oauth2.client.oidc.server.session.ReactiveOidcSessionRegistry;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizationRequestResolver;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.security.web.server.authentication.ServerAuthenticationFailureHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.security.web.server.util.matcher.OrServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.web.cors.reactive.CorsWebFilter;
import org.springframework.web.server.WebFilter;
import reactor.core.publisher.Mono;

@Conditional(value={IsClientWithLoginCondition.class, IsNotServlet.class})
@EnableWebFluxSecurity
@AutoConfiguration
@ImportAutoConfiguration(value={ReactiveSpringAddonsOidcBeans.class})
public class ReactiveSpringAddonsOidcClientWithLoginBeans {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactiveSpringAddonsOidcClientWithLoginBeans.class);

    @Order(value=0x7FFFFFFE)
    @Bean
    SecurityWebFilterChain clientFilterChain(ServerHttpSecurity http, ServerProperties serverProperties, SpringAddonsOidcProperties addonsProperties, ServerOAuth2AuthorizationRequestResolver authorizationRequestResolver, PreAuthorizationCodeServerRedirectStrategy preAuthorizationCodeRedirectStrategy, ServerAuthenticationEntryPoint authenticationEntryPoint, ServerAuthenticationSuccessHandler authenticationSuccessHandler, ServerAuthenticationFailureHandler authenticationFailureHandler, ServerLogoutSuccessHandler logoutSuccessHandler, ClientAuthorizeExchangeSpecPostProcessor authorizePostProcessor, ClientReactiveHttpSecurityPostProcessor httpPostProcessor, Optional<ServerLogoutHandler> logoutHandler, Optional<OidcBackChannelServerLogoutHandler> oidcBackChannelLogoutHandler) throws Exception {
        List<ServerWebExchangeMatcher> clientRoutes = addonsProperties.getClient().getSecurityMatchers().stream().map(PathPatternParserServerWebExchangeMatcher::new).map(ServerWebExchangeMatcher.class::cast).toList();
        log.info("Applying client OAuth2 configuration for: {}", addonsProperties.getClient().getSecurityMatchers());
        http.securityMatcher((ServerWebExchangeMatcher)new OrServerWebExchangeMatcher(clientRoutes));
        http.exceptionHandling(exceptions -> exceptions.authenticationEntryPoint(authenticationEntryPoint));
        http.oauth2Login(oauth2 -> {
            oauth2.authorizationRequestResolver(authorizationRequestResolver);
            oauth2.authorizationRedirectStrategy((ServerRedirectStrategy)preAuthorizationCodeRedirectStrategy);
            oauth2.authenticationSuccessHandler(authenticationSuccessHandler);
            oauth2.authenticationFailureHandler(authenticationFailureHandler);
        });
        http.logout(logout -> {
            logoutHandler.ifPresent(handler -> {
                if (!(handler instanceof OidcBackChannelServerLogoutHandler)) {
                    logout.logoutHandler(handler);
                }
            });
            logout.logoutSuccessHandler(logoutSuccessHandler);
        });
        if (oidcBackChannelLogoutHandler.isPresent()) {
            http.oidcLogout(ol -> ol.backChannel(bc -> bc.logoutHandler((ServerLogoutHandler)oidcBackChannelLogoutHandler.get())));
        }
        ReactiveConfigurationSupport.configureClient(http, serverProperties, addonsProperties, authorizePostProcessor, httpPostProcessor);
        return http.build();
    }

    @ConditionalOnMissingBean
    @Bean
    LogoutRequestUriBuilder logoutRequestUriBuilder(SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsOAuth2LogoutRequestUriBuilder(addonsProperties.getClient());
    }

    @ConditionalOnMissingBean
    @Bean
    ServerLogoutSuccessHandler logoutSuccessHandler(LogoutRequestUriBuilder logoutUriBuilder, ReactiveClientRegistrationRepository clientRegistrationRepo, SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsServerLogoutSuccessHandler(logoutUriBuilder, clientRegistrationRepo, addonsProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    ClientAuthorizeExchangeSpecPostProcessor clientAuthorizePostProcessor() {
        return spec -> spec.anyExchange().authenticated();
    }

    @ConditionalOnMissingBean
    @Bean
    ClientReactiveHttpSecurityPostProcessor clientHttpPostProcessor() {
        return serverHttpSecurity -> serverHttpSecurity;
    }

    @Conditional(value={CookieCsrfCondition.class})
    @ConditionalOnMissingBean(name={"csrfCookieWebFilter"})
    @Bean
    WebFilter csrfCookieWebFilter() {
        return (exchange, chain) -> {
            ((Mono)exchange.getAttributeOrDefault(CsrfToken.class.getName(), (Object)Mono.empty())).subscribe();
            return chain.filter(exchange);
        };
    }

    @ConditionalOnMissingBean
    @Bean
    ServerOAuth2AuthorizationRequestResolver authorizationRequestResolver(OAuth2ClientProperties bootClientProperties, ReactiveClientRegistrationRepository clientRegistrationRepository, SpringAddonsOidcProperties addonsProperties, WebFluxProperties serverProperties) {
        return new SpringAddonsServerOAuth2AuthorizationRequestResolver(bootClientProperties, clientRegistrationRepository, addonsProperties.getClient(), serverProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    PreAuthorizationCodeServerRedirectStrategy preAuthorizationCodeRedirectStrategy(SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsPreAuthorizationCodeServerRedirectStrategy(addonsProperties.getClient().getOauth2Redirections().getPreAuthorizationCode());
    }

    @Conditional(value={DefaultAuthenticationEntryPointCondition.class})
    @Bean
    ServerAuthenticationEntryPoint authenticationEntryPoint(SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsServerAuthenticationEntryPoint(addonsProperties.getClient());
    }

    @Conditional(value={DefaultAuthenticationSuccessHandlerCondition.class})
    @Bean
    ServerAuthenticationSuccessHandler authenticationSuccessHandler(SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsOauth2ServerAuthenticationSuccessHandler(addonsProperties);
    }

    @Conditional(value={DefaultAuthenticationFailureHandlerCondition.class})
    @Bean
    ServerAuthenticationFailureHandler authenticationFailureHandler(SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsOauth2ServerAuthenticationFailureHandler(addonsProperties);
    }

    @Conditional(value={DefaultCorsWebFilterCondition.class})
    @Bean
    CorsWebFilter corsFilter(SpringAddonsOidcProperties addonsProperties) {
        ArrayList<CorsProperties> corsProps = new ArrayList<CorsProperties>(addonsProperties.getCors());
        List<CorsProperties> deprecatedClientCorsProps = addonsProperties.getClient().getCors();
        corsProps.addAll(deprecatedClientCorsProps);
        return ReactiveConfigurationSupport.getCorsFilterBean(corsProps);
    }

    @Conditional(value={DefaultOidcSessionRegistryCondition.class})
    @Bean
    ReactiveOidcSessionRegistry oidcSessionRegistry() {
        return new InMemoryReactiveOidcSessionRegistry();
    }

    @Conditional(value={DefaultOidcBackChannelLogoutHandlerCondition.class})
    @Bean
    OidcBackChannelServerLogoutHandler oidcBackChannelLogoutHandler(ReactiveOidcSessionRegistry sessionRegistry, SpringAddonsOidcProperties addonsProperties) {
        OidcBackChannelServerLogoutHandler logoutHandler = new OidcBackChannelServerLogoutHandler(sessionRegistry);
        addonsProperties.getClient().getBackChannelLogout().getInternalLogoutUri().ifPresent(arg_0 -> ((OidcBackChannelServerLogoutHandler)logoutHandler).setLogoutUri(arg_0));
        addonsProperties.getClient().getBackChannelLogout().getCookieName().ifPresent(arg_0 -> ((OidcBackChannelServerLogoutHandler)logoutHandler).setSessionCookieName(arg_0));
        return logoutHandler;
    }

    public static interface PreAuthorizationCodeServerRedirectStrategy
    extends ServerRedirectStrategy {
    }

    public static class SpringAddonsPreAuthorizationCodeServerRedirectStrategy
    extends SpringAddonsOauth2ServerRedirectStrategy
    implements PreAuthorizationCodeServerRedirectStrategy {
        public SpringAddonsPreAuthorizationCodeServerRedirectStrategy(HttpStatus defaultStatus) {
            super(defaultStatus);
        }
    }
}

