/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.synchronised.client;

import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcClientProperties;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.web.util.UriComponentsBuilder;

public class SpringAddonsAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringAddonsAuthenticationEntryPoint.class);
    private final SpringAddonsOidcClientProperties clientProperties;

    public SpringAddonsAuthenticationEntryPoint(SpringAddonsOidcClientProperties addonsProperties) {
        this.clientProperties = addonsProperties;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        String location = this.clientProperties.getLoginUri().orElseGet(() -> this.clientProperties.getClientUri().map(clientUri -> UriComponentsBuilder.fromUri((URI)clientUri).pathSegment(new String[]{clientUri.getPath(), "login"}).build().toUri()).orElse(URI.create("/login"))).toString();
        log.debug("Status: {}, location: {}", (Object)this.clientProperties.getOauth2Redirections().getAuthenticationEntryPoint().value(), (Object)location);
        response.setStatus(this.clientProperties.getOauth2Redirections().getAuthenticationEntryPoint().value());
        response.setHeader("WWW-Authenticate", "OAuth realm=%s".formatted(location));
        response.setHeader("Location", location.toString());
        if (this.clientProperties.getOauth2Redirections().getAuthenticationEntryPoint().is4xxClientError() || this.clientProperties.getOauth2Redirections().getAuthenticationEntryPoint().is5xxServerError()) {
            response.getOutputStream().write("Unauthorized. Please authenticate at %s".formatted(location.toString()).getBytes());
        }
        response.flushBuffer();
    }
}

