/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive.client;

import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import java.net.URI;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.ServerAuthenticationFailureHandler;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SpringAddonsOauth2ServerAuthenticationFailureHandler
implements ServerAuthenticationFailureHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringAddonsOauth2ServerAuthenticationFailureHandler.class);
    private final URI defaultRedirectUri;
    private final HttpStatus postAuthorizationFailureStatus;

    public SpringAddonsOauth2ServerAuthenticationFailureHandler(SpringAddonsOidcProperties addonsProperties) {
        this.defaultRedirectUri = addonsProperties.getClient().getLoginErrorRedirectPath().orElse(URI.create("/"));
        this.postAuthorizationFailureStatus = addonsProperties.getClient().getOauth2Redirections().getPostAuthorizationFailure();
    }

    public Mono<Void> onAuthenticationFailure(WebFilterExchange webFilterExchange, AuthenticationException exception) {
        return webFilterExchange.getExchange().getSession().flatMap(session -> {
            String location = UriComponentsBuilder.fromUri((URI)((URI)session.getAttributeOrDefault("post_login_failure_uri", (Object)this.defaultRedirectUri))).queryParam("error", new Object[]{HtmlUtils.htmlEscape((String)exception.getMessage())}).build().toUri().toString();
            ServerHttpResponse response = webFilterExchange.getExchange().getResponse();
            response.setStatusCode((HttpStatusCode)this.postAuthorizationFailureStatus);
            response.getHeaders().add("Location", location);
            response.getHeaders().add("error", exception.getMessage());
            log.debug("Login failure. Status: {}, location: {}, message: {}", new Object[]{this.postAuthorizationFailureStatus, location, exception.getMessage()});
            if (this.postAuthorizationFailureStatus.is4xxClientError() || this.postAuthorizationFailureStatus.is5xxServerError()) {
                DataBuffer buffer = response.bufferFactory().wrap(exception.getMessage().getBytes());
                return response.writeWith((Publisher)Flux.just((Object)buffer));
            }
            return response.setComplete();
        });
    }
}

