/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive.client;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SpringAddonsOauth2ServerRedirectStrategy
implements ServerRedirectStrategy {
    private final HttpStatus defaultStatus;

    public Mono<Void> sendRedirect(ServerWebExchange exchange, URI location) {
        return Mono.fromRunnable(() -> {
            ServerHttpResponse response = exchange.getResponse();
            HttpStatus status = this.statusHeader(exchange).orElseGet(() -> this.statusParam(exchange).orElse(this.defaultStatus));
            response.setStatusCode((HttpStatusCode)status);
            response.getHeaders().setLocation(location);
        });
    }

    private Optional<HttpStatus> statusHeader(ServerWebExchange exchange) {
        if (exchange == null || exchange.getRequest() == null || exchange.getRequest().getHeaders() == null) {
            return Optional.empty();
        }
        return this.toStatus(this.anyOf(exchange.getRequest().getHeaders().get((Object)"X-RESPONSE-STATUS")));
    }

    private Optional<HttpStatus> statusParam(ServerWebExchange exchange) {
        if (exchange == null || exchange.getRequest() == null || exchange.getRequest().getQueryParams() == null) {
            return Optional.empty();
        }
        return this.toStatus(this.anyOf((List)exchange.getRequest().getQueryParams().get((Object)"response_http_status")));
    }

    private Optional<String> anyOf(List<String> values) {
        return Optional.ofNullable(values).map(Collection::stream).orElse(Stream.empty()).filter(StringUtils::hasLength).findAny();
    }

    private Optional<HttpStatus> toStatus(Optional<String> statusStr) {
        return statusStr.map(str -> {
            try {
                int statusCode = Integer.parseInt(str);
                return HttpStatus.valueOf((int)statusCode);
            }
            catch (NumberFormatException e) {
                return HttpStatus.valueOf((String)str.toUpperCase());
            }
        });
    }

    @Generated
    public SpringAddonsOauth2ServerRedirectStrategy(HttpStatus defaultStatus) {
        this.defaultStatus = defaultStatus;
    }

    @Generated
    public HttpStatus getDefaultStatus() {
        return this.defaultStatus;
    }
}

