/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.synchronised.client;

import com.c4_soft.springaddons.security.oidc.starter.LogoutRequestUriBuilder;
import com.c4_soft.springaddons.security.oidc.starter.properties.InvalidRedirectionUriException;
import com.c4_soft.springaddons.security.oidc.starter.properties.MisconfiguredPostLogoutUriException;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.SpringAddonsOauth2RedirectStrategy;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.util.StringUtils;

public class SpringAddonsLogoutSuccessHandler
extends SimpleUrlLogoutSuccessHandler {
    private final LogoutRequestUriBuilder uriBuilder;
    private final ClientRegistrationRepository clientRegistrationRepository;
    private final SpringAddonsOauth2RedirectStrategy redirectStrategy;
    private final String defaultPostLogoutUri;
    private final List<Pattern> postLogoutAllowedUriPatterns;

    public SpringAddonsLogoutSuccessHandler(LogoutRequestUriBuilder uriBuilder, ClientRegistrationRepository clientRegistrationRepository, SpringAddonsOidcProperties addonsProperties) {
        this.postLogoutAllowedUriPatterns = addonsProperties.getClient().getPostLogoutAllowedUriPatterns();
        this.defaultPostLogoutUri = Optional.ofNullable(addonsProperties.getClient().getPostLogoutRedirectUri()).map(URI::toString).orElse(null);
        if (this.postLogoutAllowedUriPatterns.stream().noneMatch(p -> p.matcher(this.defaultPostLogoutUri).matches())) {
            throw new MisconfiguredPostLogoutUriException(URI.create(this.defaultPostLogoutUri), this.postLogoutAllowedUriPatterns);
        }
        this.uriBuilder = uriBuilder;
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.redirectStrategy = new SpringAddonsOauth2RedirectStrategy(addonsProperties.getClient().getOauth2Redirections().getRpInitiatedLogout());
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        OAuth2AuthenticationToken oauth;
        OAuth2User oAuth2User;
        if (authentication instanceof OAuth2AuthenticationToken && (oAuth2User = (oauth = (OAuth2AuthenticationToken)authentication).getPrincipal()) instanceof OidcUser) {
            OidcUser oidcUser = (OidcUser)oAuth2User;
            String postLogoutUri = Optional.ofNullable(request.getHeader("X-POST-LOGOUT-SUCCESS-URI")).orElse(Optional.ofNullable(request.getParameter("post_logout_success_uri")).orElse(this.defaultPostLogoutUri));
            if (this.postLogoutAllowedUriPatterns.stream().noneMatch(p -> p.matcher(postLogoutUri).matches())) {
                throw new InvalidRedirectionUriException(URI.create(postLogoutUri));
            }
            ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(oauth.getAuthorizedClientRegistrationId());
            Optional<String> uri = StringUtils.hasText((String)postLogoutUri) ? this.uriBuilder.getLogoutRequestUri(clientRegistration, oidcUser.getIdToken().getTokenValue(), Optional.of(URI.create(postLogoutUri))) : this.uriBuilder.getLogoutRequestUri(clientRegistration, oidcUser.getIdToken().getTokenValue());
            return uri.orElse(null);
        }
        return null;
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        this.redirectStrategy.sendRedirect(request, response, this.determineTargetUrl(request, response, authentication));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringAddonsLogoutSuccessHandler)) {
            return false;
        }
        SpringAddonsLogoutSuccessHandler other = (SpringAddonsLogoutSuccessHandler)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LogoutRequestUriBuilder this$uriBuilder = this.uriBuilder;
        LogoutRequestUriBuilder other$uriBuilder = other.uriBuilder;
        if (this$uriBuilder == null ? other$uriBuilder != null : !this$uriBuilder.equals(other$uriBuilder)) {
            return false;
        }
        ClientRegistrationRepository this$clientRegistrationRepository = this.clientRegistrationRepository;
        ClientRegistrationRepository other$clientRegistrationRepository = other.clientRegistrationRepository;
        if (this$clientRegistrationRepository == null ? other$clientRegistrationRepository != null : !this$clientRegistrationRepository.equals(other$clientRegistrationRepository)) {
            return false;
        }
        SpringAddonsOauth2RedirectStrategy this$redirectStrategy = this.redirectStrategy;
        SpringAddonsOauth2RedirectStrategy other$redirectStrategy = other.redirectStrategy;
        if (this$redirectStrategy == null ? other$redirectStrategy != null : !this$redirectStrategy.equals(other$redirectStrategy)) {
            return false;
        }
        String this$defaultPostLogoutUri = this.defaultPostLogoutUri;
        String other$defaultPostLogoutUri = other.defaultPostLogoutUri;
        if (this$defaultPostLogoutUri == null ? other$defaultPostLogoutUri != null : !this$defaultPostLogoutUri.equals(other$defaultPostLogoutUri)) {
            return false;
        }
        List<Pattern> this$postLogoutAllowedUriPatterns = this.postLogoutAllowedUriPatterns;
        List<Pattern> other$postLogoutAllowedUriPatterns = other.postLogoutAllowedUriPatterns;
        return !(this$postLogoutAllowedUriPatterns == null ? other$postLogoutAllowedUriPatterns != null : !((Object)this$postLogoutAllowedUriPatterns).equals(other$postLogoutAllowedUriPatterns));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpringAddonsLogoutSuccessHandler;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        LogoutRequestUriBuilder $uriBuilder = this.uriBuilder;
        result = result * 59 + ($uriBuilder == null ? 43 : $uriBuilder.hashCode());
        ClientRegistrationRepository $clientRegistrationRepository = this.clientRegistrationRepository;
        result = result * 59 + ($clientRegistrationRepository == null ? 43 : $clientRegistrationRepository.hashCode());
        SpringAddonsOauth2RedirectStrategy $redirectStrategy = this.redirectStrategy;
        result = result * 59 + ($redirectStrategy == null ? 43 : $redirectStrategy.hashCode());
        String $defaultPostLogoutUri = this.defaultPostLogoutUri;
        result = result * 59 + ($defaultPostLogoutUri == null ? 43 : $defaultPostLogoutUri.hashCode());
        List<Pattern> $postLogoutAllowedUriPatterns = this.postLogoutAllowedUriPatterns;
        result = result * 59 + ($postLogoutAllowedUriPatterns == null ? 43 : ((Object)$postLogoutAllowedUriPatterns).hashCode());
        return result;
    }
}

