/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive.client;

import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcClientProperties;
import java.net.URI;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SpringAddonsServerAuthenticationEntryPoint
implements ServerAuthenticationEntryPoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringAddonsServerAuthenticationEntryPoint.class);
    private final SpringAddonsOidcClientProperties clientProperties;

    public SpringAddonsServerAuthenticationEntryPoint(SpringAddonsOidcClientProperties addonsProperties) {
        this.clientProperties = addonsProperties;
    }

    public Mono<Void> commence(ServerWebExchange exchange, AuthenticationException ex) {
        String location = this.clientProperties.getLoginUri().orElseGet(() -> this.clientProperties.getClientUri().map(clientUri -> UriComponentsBuilder.fromUri((URI)clientUri).pathSegment(new String[]{clientUri.getPath(), "login"}).build().toUri()).orElse(URI.create("/login"))).toString();
        log.debug("Status: {}, location: {}", (Object)this.clientProperties.getOauth2Redirections().getAuthenticationEntryPoint().value(), (Object)location);
        ServerHttpResponse response = exchange.getResponse();
        response.setStatusCode((HttpStatusCode)this.clientProperties.getOauth2Redirections().getAuthenticationEntryPoint());
        response.getHeaders().set("WWW-Authenticate", "OAuth realm=%s".formatted(location));
        response.getHeaders().add("Location", location.toString());
        if (this.clientProperties.getOauth2Redirections().getAuthenticationEntryPoint().is4xxClientError() || this.clientProperties.getOauth2Redirections().getAuthenticationEntryPoint().is5xxServerError()) {
            DataBuffer buffer = response.bufferFactory().wrap("Unauthorized. Please authenticate at %s".formatted(location.toString()).getBytes());
            return response.writeWith((Publisher)Flux.just((Object)buffer));
        }
        return response.setComplete();
    }
}

