/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.synchronised.client;

import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.SpringAddonsOauth2RedirectStrategy;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

public class SpringAddonsOauth2AuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringAddonsOauth2AuthenticationSuccessHandler.class);
    private final String redirectUri;
    private final SpringAddonsOauth2RedirectStrategy redirectStrategy;

    public SpringAddonsOauth2AuthenticationSuccessHandler(SpringAddonsOidcProperties addonsProperties) {
        this.redirectUri = addonsProperties.getClient().getPostLoginRedirectUri().map(URI::toString).orElse("/");
        this.redirectStrategy = new SpringAddonsOauth2RedirectStrategy(addonsProperties.getClient().getOauth2Redirections().getPostAuthorizationCode());
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String uri = Optional.ofNullable(request.getSession().getAttribute("post_login_success_uri")).map(Object::toString).orElse(this.redirectUri);
        log.debug("Authentication success. Status: {}, location: {}", (Object)this.redirectStrategy.getDefaultStatus(), (Object)uri);
        this.redirectStrategy.sendRedirect(request, response, uri);
    }
}

