/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive.client;

import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.SpringAddonsOauth2ServerRedirectStrategy;
import java.net.URI;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import reactor.core.publisher.Mono;

public class SpringAddonsOauth2ServerAuthenticationSuccessHandler
implements ServerAuthenticationSuccessHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringAddonsOauth2ServerAuthenticationSuccessHandler.class);
    private final URI defaultRedirectUri;
    private final SpringAddonsOauth2ServerRedirectStrategy redirectStrategy;

    public SpringAddonsOauth2ServerAuthenticationSuccessHandler(SpringAddonsOidcProperties addonsProperties) {
        this.defaultRedirectUri = addonsProperties.getClient().getPostLoginRedirectUri().orElse(URI.create("/"));
        this.redirectStrategy = new SpringAddonsOauth2ServerRedirectStrategy(addonsProperties.getClient().getOauth2Redirections().getPostAuthorizationCode());
    }

    public Mono<Void> onAuthenticationSuccess(WebFilterExchange webFilterExchange, Authentication authentication) {
        return webFilterExchange.getExchange().getSession().flatMap(session -> {
            URI uri = (URI)session.getAttributeOrDefault("post_login_success_uri", (Object)this.defaultRedirectUri);
            log.debug("Login success. Status: {}, location: {}", (Object)this.redirectStrategy.getDefaultStatus(), (Object)uri.toString());
            return this.redirectStrategy.sendRedirect(webFilterExchange.getExchange(), uri);
        });
    }
}

