/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config.synchronised;

import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsOAuth2ClientProperties;
import com.c4_soft.springaddons.security.oauth2.config.synchronised.SpringAddonsOAuth2AuthorizedClientRepository;
import jakarta.servlet.http.HttpSession;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnProperty(value={"com.c4-soft.springaddons.security.client.back-channel-logout-enabled"})
@AutoConfiguration
@Import(value={SpringAddonsOAuth2ClientProperties.class})
public class SpringAddonsBackChannelLogoutBeans {
    @Order(value=-2147483648)
    @Bean
    SecurityFilterChain springAddonsBackChannelLogoutClientFilterChain(HttpSecurity http, ServerProperties serverProperties) throws Exception {
        http.securityMatcher((RequestMatcher)new AntPathRequestMatcher("/backchannel_logout"));
        http.authorizeHttpRequests(authorizeHttpRequests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeHttpRequests.anyRequest()).permitAll());
        if (serverProperties.getSsl() != null && serverProperties.getSsl().isEnabled()) {
            http.requiresChannel(channel -> ((ChannelSecurityConfigurer.RequiresChannelUrl)channel.anyRequest()).requiresSecure());
        }
        http.cors(cors -> cors.disable());
        http.sessionManagement(sessionManagement -> sessionManagement.sessionCreationPolicy(SessionCreationPolicy.STATELESS));
        http.csrf(csrf -> csrf.disable());
        return (SecurityFilterChain)http.build();
    }

    @Component
    @RestController
    public static class BackChannelLogoutController {
        private final SpringAddonsOAuth2AuthorizedClientRepository authorizedClientRepository;
        private final Map<String, JwtDecoder> jwtDecoders;

        public BackChannelLogoutController(SpringAddonsOAuth2AuthorizedClientRepository authorizedClientRepository, InMemoryClientRegistrationRepository registrationRepo) {
            this.authorizedClientRepository = authorizedClientRepository;
            this.jwtDecoders = StreamSupport.stream(registrationRepo.spliterator(), false).filter(reg -> AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)reg.getAuthorizationGrantType())).map(ClientRegistration::getProviderDetails).collect(Collectors.toMap(provider -> provider.getIssuerUri(), provider -> NimbusJwtDecoder.withJwkSetUri((String)provider.getJwkSetUri()).build()));
        }

        @PostMapping(path={"/backchannel_logout"}, consumes={"application/x-www-form-urlencoded"})
        public ResponseEntity<Void> backChannelLogout(@RequestParam MultiValueMap<String, String> body) {
            List tokenString = (List)body.get((Object)"logout_token");
            if (tokenString == null || tokenString.size() != 1) {
                throw new BadLogoutRequestException();
            }
            this.jwtDecoders.forEach((issuer, decoder) -> {
                try {
                    Jwt jwt = decoder.decode((String)tokenString.get(0));
                    Boolean isLogoutToken = Optional.ofNullable(jwt.getClaims().get("events")).map(Object::toString).map(evt -> evt.contains("http://schemas.openid.net/event/backchannel-logout")).orElse(false);
                    if (!isLogoutToken.booleanValue()) {
                        throw new BadLogoutRequestException();
                    }
                    String logoutIss = Optional.ofNullable(jwt.getIssuer()).map(URL::toString).orElse(null);
                    if (!Objects.equals(issuer, logoutIss)) {
                        throw new BadLogoutRequestException();
                    }
                    String logoutSub = jwt.getSubject();
                    Collection<HttpSession> sessionsToInvalidate = this.authorizedClientRepository.removeAuthorizedClients(logoutIss, logoutSub);
                    sessionsToInvalidate.forEach(s -> s.invalidate());
                }
                catch (JwtException jwtException) {
                    // empty catch block
                }
            });
            return ResponseEntity.ok().build();
        }

        @ResponseStatus(value=HttpStatus.BAD_REQUEST)
        static final class BadLogoutRequestException
        extends RuntimeException {
            private static final long serialVersionUID = -8703279699142477824L;

            BadLogoutRequestException() {
            }
        }
    }
}

