/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config.synchronised;

import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsOAuth2ClientProperties;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.web.util.UriComponentsBuilder;

public class SpringAddonsOAuth2AuthorizationRequestResolver
implements OAuth2AuthorizationRequestResolver {
    private static final String REGISTRATION_ID_URI_VARIABLE_NAME = "registrationId";
    private final DefaultOAuth2AuthorizationRequestResolver delegate;
    private final Map<String, Consumer<OAuth2AuthorizationRequest.Builder>> authRequestCustomizers = new HashMap<String, Consumer<OAuth2AuthorizationRequest.Builder>>();
    private final AntPathRequestMatcher authorizationRequestMatcher = new AntPathRequestMatcher("/oauth2/authorization/{registrationId}");

    public SpringAddonsOAuth2AuthorizationRequestResolver(InMemoryClientRegistrationRepository clientRegistrationRepository, SpringAddonsOAuth2ClientProperties addonsClientProperties) {
        clientRegistrationRepository.forEach(reg -> {
            SpringAddonsOAuth2ClientProperties.RequestParam[] params = (SpringAddonsOAuth2ClientProperties.RequestParam[])addonsClientProperties.getAuthorizationRequestParams().get(reg.getRegistrationId());
            if (params != null) {
                this.authRequestCustomizers.put(reg.getRegistrationId(), SpringAddonsOAuth2AuthorizationRequestResolver.requestParamAuthorizationRequestCustomizer(params));
            }
        });
        this.delegate = new DefaultOAuth2AuthorizationRequestResolver((ClientRegistrationRepository)clientRegistrationRepository, "/oauth2/authorization");
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request) {
        String registrationId = this.resolveRegistrationId(request);
        this.delegate.setAuthorizationRequestCustomizer(this.authRequestCustomizers.getOrDefault(registrationId, b -> {}));
        OAuth2AuthorizationRequest resolved = this.delegate.resolve(request);
        OAuth2AuthorizationRequest absolute = this.toAbsolute(resolved, request);
        return absolute;
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request, String clientRegistrationId) {
        this.delegate.setAuthorizationRequestCustomizer(this.authRequestCustomizers.getOrDefault(clientRegistrationId, b -> {}));
        OAuth2AuthorizationRequest resolved = this.delegate.resolve(request, clientRegistrationId);
        OAuth2AuthorizationRequest absolute = this.toAbsolute(resolved, request);
        return absolute;
    }

    private OAuth2AuthorizationRequest toAbsolute(OAuth2AuthorizationRequest defaultAuthorizationRequest, HttpServletRequest request) {
        StringBuffer clientUriString = request.getRequestURL();
        if (defaultAuthorizationRequest == null || clientUriString == null) {
            return defaultAuthorizationRequest;
        }
        URI clientUri = URI.create(clientUriString.toString());
        String redirectUri = UriComponentsBuilder.fromUriString((String)defaultAuthorizationRequest.getRedirectUri()).scheme(clientUri.getScheme()).host(clientUri.getHost()).port(clientUri.getPort()).build().toUriString();
        return OAuth2AuthorizationRequest.from((OAuth2AuthorizationRequest)defaultAuthorizationRequest).redirectUri(redirectUri).authorizationRequestUri(defaultAuthorizationRequest.getAuthorizationRequestUri()).build();
    }

    private String resolveRegistrationId(HttpServletRequest request) {
        if (this.authorizationRequestMatcher.matches(request)) {
            return (String)this.authorizationRequestMatcher.matcher(request).getVariables().get(REGISTRATION_ID_URI_VARIABLE_NAME);
        }
        return null;
    }

    private static Consumer<OAuth2AuthorizationRequest.Builder> requestParamAuthorizationRequestCustomizer(SpringAddonsOAuth2ClientProperties.RequestParam[] additionalParams) {
        return customizer -> customizer.authorizationRequestUri(authorizationRequestUri -> {
            for (SpringAddonsOAuth2ClientProperties.RequestParam reqParam : additionalParams) {
                authorizationRequestUri.queryParam(reqParam.getName(), new Object[]{reqParam.getValue()});
            }
            return authorizationRequestUri.build(new Object[0]);
        });
    }
}

