/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config.synchronised;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionIdListener;
import jakarta.servlet.http.HttpSessionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.authentication.OAuth2LoginAuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.user.OAuth2User;

public class SpringAddonsOAuth2AuthorizedClientRepository
implements OAuth2AuthorizedClientRepository,
HttpSessionListener,
HttpSessionIdListener {
    private static final String OAUTH2_USERS_KEY = "com.c4-soft.spring-addons.OAuth2.client.oauth2-users";
    private static final String AUTHORIZED_CLIENTS_KEY = "com.c4-soft.spring-addons.OAuth2.client.authorized-clients";
    private static final Map<UserId, Set<HttpSession>> sessionsByuserId = new ConcurrentHashMap<UserId, Set<HttpSession>>();
    private static final Map<String, Set<UserId>> userIdsBySessionId = new ConcurrentHashMap<String, Set<UserId>>();
    private final ClientRegistrationRepository clientRegistrationRepository;

    public void sessionIdChanged(HttpSessionEvent event, String oldSessionId) {
        if (userIdsBySessionId.containsKey(oldSessionId) && !Objects.equals(event.getSession().getId(), oldSessionId)) {
            userIdsBySessionId.put(event.getSession().getId(), userIdsBySessionId.get(oldSessionId));
            userIdsBySessionId.remove(oldSessionId);
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        Set<UserId> idsToUpdate = this.getUserIds(se.getSession().getId());
        for (UserId id : idsToUpdate) {
            this.setSessions(id.iss(), id.sub(), new HashSet<HttpSession>(this.getSessions(id.iss(), id.sub()).stream().filter(s -> !s.getId().equals(se.getSession().getId())).collect(Collectors.toSet())));
        }
        userIdsBySessionId.remove(se.getSession().getId());
    }

    private Optional<String> getUserSubject(HttpSession session, String issuer) {
        Map<String, OAuth2User> oauth2Users = this.getOAuth2Users(session);
        return Optional.ofNullable(oauth2Users.get(issuer)).map(u -> (String)u.getAttribute("sub"));
    }

    public <T extends OAuth2AuthorizedClient> T loadAuthorizedClient(String clientRegistrationId, Authentication auth, HttpServletRequest request) {
        String issuer = this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId).getProviderDetails().getIssuerUri();
        String subject = this.getUserSubject(request.getSession(), issuer).orElse(auth.getName());
        return (T)this.loadAuthorizedClient(request.getSession(), issuer, subject);
    }

    public OAuth2AuthorizedClient loadAuthorizedClient(HttpSession session, String issuer, String subject) {
        Set<OAuth2AuthorizedClient> authorizedClients = this.getAuthorizedClients(session);
        return authorizedClients.stream().filter(ac -> Objects.equals(ac.getClientRegistration().getProviderDetails().getIssuerUri(), issuer) && Objects.equals(ac.getPrincipalName(), subject)).findAny().orElse(null);
    }

    public void saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication auth, HttpServletRequest request, HttpServletResponse response) {
        if (auth instanceof OAuth2LoginAuthenticationToken || auth instanceof OAuth2AuthenticationToken) {
            this.saveAuthorizedClient(request.getSession(), authorizedClient, (OAuth2User)auth.getPrincipal());
        }
    }

    private void saveAuthorizedClient(HttpSession session, OAuth2AuthorizedClient authorizedClient, OAuth2User user) {
        String issuer = authorizedClient.getClientRegistration().getProviderDetails().getIssuerUri();
        String subject = user.getAttributes().get("sub").toString();
        Map<String, OAuth2User> oauth2Users = this.getOAuth2Users(session);
        if (oauth2Users.containsKey(issuer)) {
            this.removeAuthorizedClient(session, issuer, oauth2Users.get(issuer).getName());
        }
        oauth2Users.put(issuer, user);
        this.setOAuth2Users(session, oauth2Users);
        Set<OAuth2AuthorizedClient> authorizedClients = this.getAuthorizedClients(session);
        authorizedClients.add(authorizedClient);
        this.setAuthorizedClients(session, authorizedClients);
        Set<HttpSession> sessions = this.getSessions(issuer, subject);
        if (!sessions.contains(session)) {
            sessions.add(session);
            this.setSessions(issuer, subject, sessions);
        }
        Set<UserId> userIds = this.getUserIds(session.getId());
        userIds.add(new UserId(issuer, subject));
        this.setUserIds(session.getId(), userIds);
    }

    public void removeAuthorizedClient(String clientRegistrationId, Authentication auth, HttpServletRequest request, HttpServletResponse response) {
        if (auth instanceof OAuth2LoginAuthenticationToken || auth instanceof OAuth2AuthenticationToken) {
            String issuer = this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId).getProviderDetails().getIssuerUri();
            String subject = this.getUserSubject(request.getSession(), issuer).orElse(auth.getName());
            this.removeAuthorizedClient(request.getSession(), issuer, subject);
        }
    }

    public void removeAuthorizedClient(HttpSession session, String issuer, String subject) {
        Set<HttpSession> sessions;
        Set<OAuth2AuthorizedClient> allAuthorizedClients = this.getAuthorizedClients(session);
        Set authorizedClientsToRemove = allAuthorizedClients.stream().filter(ac -> Objects.equals(ac.getClientRegistration().getProviderDetails().getIssuerUri(), issuer) && Objects.equals(ac.getPrincipalName(), subject)).collect(Collectors.toSet());
        allAuthorizedClients.removeAll(authorizedClientsToRemove);
        this.setAuthorizedClients(session, allAuthorizedClients);
        Map<String, OAuth2User> oauth2Users = this.getOAuth2Users(session);
        if (oauth2Users.containsKey(issuer)) {
            oauth2Users.remove(issuer);
            this.setOAuth2Users(session, oauth2Users);
        }
        if ((sessions = this.getSessions(issuer, subject)).contains(session)) {
            sessions.remove(session);
            this.setSessions(issuer, subject, sessions);
        }
        Set<UserId> userIds = this.getUserIds(session.getId());
        userIds.remove(new UserId(issuer, subject));
    }

    public Collection<HttpSession> removeAuthorizedClients(String issuer, String subject) {
        Set<HttpSession> sessions = this.getSessions(issuer, subject);
        List<HttpSession> sessionsToInvalidate = sessions.stream().filter(s -> this.getAuthorizedClients((HttpSession)s).stream().filter(authorizedClient -> authorizedClient.getClientRegistration().getProviderDetails().getIssuerUri().equals(issuer) && authorizedClient.getPrincipalName().equals(subject)).count() < 1L).toList();
        for (HttpSession session : sessions) {
            this.removeAuthorizedClient(session, issuer, subject);
        }
        return sessionsToInvalidate;
    }

    private Set<OAuth2AuthorizedClient> getAuthorizedClients(HttpSession session) {
        Set sessionAuthorizedClients = (Set)session.getAttribute(AUTHORIZED_CLIENTS_KEY);
        return sessionAuthorizedClients == null ? new HashSet() : sessionAuthorizedClients;
    }

    private void setAuthorizedClients(HttpSession session, Set<OAuth2AuthorizedClient> sessionAuthorizedClients) {
        session.setAttribute(AUTHORIZED_CLIENTS_KEY, sessionAuthorizedClients);
    }

    public Map<String, OAuth2User> getOAuth2UsersBySession(HttpSession session) {
        if (session == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.getOAuth2Users(session));
    }

    private Map<String, OAuth2User> getOAuth2Users(HttpSession s) {
        Map sessionOauth2UsersByIssuer = (Map)s.getAttribute(OAUTH2_USERS_KEY);
        return sessionOauth2UsersByIssuer == null ? new ConcurrentHashMap() : sessionOauth2UsersByIssuer;
    }

    private void setOAuth2Users(HttpSession s, Map<String, OAuth2User> sessionOauth2UsersByIssuer) {
        s.setAttribute(OAUTH2_USERS_KEY, sessionOauth2UsersByIssuer);
    }

    private Set<HttpSession> getSessions(String issuer, String subject) {
        return sessionsByuserId.getOrDefault(new UserId(issuer, subject), new HashSet());
    }

    private void setSessions(String issuer, String subject, Set<HttpSession> sessions) {
        if (sessions == null || sessions.isEmpty()) {
            sessionsByuserId.remove(new UserId(issuer, subject));
        } else {
            sessionsByuserId.put(new UserId(issuer, subject), sessions);
        }
    }

    private Set<UserId> getUserIds(String sessionId) {
        return userIdsBySessionId.getOrDefault(sessionId, new HashSet());
    }

    private void setUserIds(String sessionId, Set<UserId> userIds) {
        if (userIds == null || userIds.isEmpty()) {
            userIdsBySessionId.remove(sessionId);
        } else {
            userIdsBySessionId.put(sessionId, userIds);
        }
    }

    @Generated
    public SpringAddonsOAuth2AuthorizedClientRepository(ClientRegistrationRepository clientRegistrationRepository) {
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    private record UserId(String iss, String sub) {
    }
}

