/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config.synchronised;

import com.c4_soft.springaddons.security.oauth2.config.ConfigurableClaimSet2AuthoritiesConverter;
import com.c4_soft.springaddons.security.oauth2.config.LogoutRequestUriBuilder;
import com.c4_soft.springaddons.security.oauth2.config.OAuth2AuthoritiesConverter;
import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsOAuth2ClientProperties;
import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsOAuth2LogoutRequestUriBuilder;
import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsSecurityProperties;
import com.c4_soft.springaddons.security.oauth2.config.synchronised.ClientExpressionInterceptUrlRegistryPostProcessor;
import com.c4_soft.springaddons.security.oauth2.config.synchronised.ClientHttpSecurityPostProcessor;
import com.c4_soft.springaddons.security.oauth2.config.synchronised.ServletConfigurationSupport;
import com.c4_soft.springaddons.security.oauth2.config.synchronised.SpringAddonsOAuth2AuthorizationRequestResolver;
import com.c4_soft.springaddons.security.oauth2.config.synchronised.SpringAddonsOAuth2AuthorizedClientRepository;
import com.c4_soft.springaddons.security.oauth2.config.synchronised.SpringAddonsOAuth2LogoutSuccessHandler;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.oidc.user.OidcUserAuthority;
import org.springframework.security.oauth2.core.user.OAuth2UserAuthority;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.util.UriComponentsBuilder;

@ConditionalOnProperty(matchIfMissing=true, prefix="com.c4-soft.springaddons.security.client", name={"enabled"})
@EnableWebSecurity
@AutoConfiguration
@Import(value={SpringAddonsOAuth2ClientProperties.class})
public class SpringAddonsOAuth2ClientBeans {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringAddonsOAuth2ClientBeans.class);

    @ConditionalOnExpression(value="!(T(org.springframework.util.StringUtils).isEmpty('${com.c4-soft.springaddons.security.client.security-matchers:}') && T(org.springframework.util.StringUtils).isEmpty('${com.c4-soft.springaddons.security.client.security-matchers[0]:}'))")
    @Order(value=-2147483647)
    @Bean
    SecurityFilterChain springAddonsClientFilterChain(HttpSecurity http, ServerProperties serverProperties, OAuth2AuthorizationRequestResolver authorizationRequestResolver, LogoutSuccessHandler logoutSuccessHandler, SpringAddonsOAuth2ClientProperties clientProps, ClientExpressionInterceptUrlRegistryPostProcessor authorizePostProcessor, ClientHttpSecurityPostProcessor httpPostProcessor) throws Exception {
        log.info("Applying client OAuth2 configuration for: {}", (Object[])clientProps.getSecurityMatchers());
        http.securityMatcher(clientProps.getSecurityMatchers());
        http.oauth2Login(login -> {
            login.authorizationEndpoint(authorizationEndpoint -> authorizationEndpoint.authorizationRequestResolver(authorizationRequestResolver));
            clientProps.getLoginPath().ifPresent(loginPath -> login.loginPage(UriComponentsBuilder.fromUri((URI)clientProps.getClientUri()).path(loginPath).build().toString()));
            clientProps.getPostLoginRedirectPath().ifPresent(postLoginRedirectPath -> login.defaultSuccessUrl(UriComponentsBuilder.fromUri((URI)clientProps.getClientUri()).path(postLoginRedirectPath).build().toString(), true));
        });
        http.logout(logout -> logout.logoutSuccessHandler(logoutSuccessHandler));
        ServletConfigurationSupport.configureClient((HttpSecurity)http, (ServerProperties)serverProperties, (SpringAddonsOAuth2ClientProperties)clientProps, (ClientExpressionInterceptUrlRegistryPostProcessor)authorizePostProcessor, (ClientHttpSecurityPostProcessor)httpPostProcessor);
        return (SecurityFilterChain)http.build();
    }

    @ConditionalOnMissingBean
    @Bean
    OAuth2AuthorizationRequestResolver oAuth2AuthorizationRequestResolver(InMemoryClientRegistrationRepository clientRegistrationRepository, SpringAddonsOAuth2ClientProperties clientProps) {
        return new SpringAddonsOAuth2AuthorizationRequestResolver(clientRegistrationRepository, clientProps);
    }

    @ConditionalOnMissingBean
    @Bean
    LogoutRequestUriBuilder logoutRequestUriBuilder(SpringAddonsOAuth2ClientProperties clientProps) {
        return new SpringAddonsOAuth2LogoutRequestUriBuilder(clientProps);
    }

    @ConditionalOnMissingBean
    @Bean
    LogoutSuccessHandler logoutSuccessHandler(LogoutRequestUriBuilder logoutRequestUriBuilder, ClientRegistrationRepository clientRegistrationRepository) {
        return new SpringAddonsOAuth2LogoutSuccessHandler(logoutRequestUriBuilder, clientRegistrationRepository);
    }

    @ConditionalOnMissingBean
    @Bean
    OAuth2AuthoritiesConverter authoritiesConverter(SpringAddonsSecurityProperties addonsProperties) {
        return new ConfigurableClaimSet2AuthoritiesConverter(addonsProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    GrantedAuthoritiesMapper grantedAuthoritiesMapper(Converter<Map<String, Object>, Collection<? extends GrantedAuthority>> authoritiesConverter) {
        return authorities -> {
            HashSet mappedAuthorities = new HashSet();
            authorities.forEach(authority -> {
                if (authority instanceof OidcUserAuthority) {
                    OidcUserAuthority oidcAuth = (OidcUserAuthority)authority;
                    mappedAuthorities.addAll((Collection)authoritiesConverter.convert((Object)oidcAuth.getIdToken().getClaims()));
                } else if (authority instanceof OAuth2UserAuthority) {
                    OAuth2UserAuthority oauth2Auth = (OAuth2UserAuthority)authority;
                    mappedAuthorities.addAll((Collection)authoritiesConverter.convert((Object)oauth2Auth.getAttributes()));
                }
            });
            return mappedAuthorities;
        };
    }

    CorsConfigurationSource corsConfig(SpringAddonsSecurityProperties.CorsProperties[] corsProperties) {
        log.debug("Building default CorsConfigurationSource with: {}", Stream.of(corsProperties).toList());
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        for (SpringAddonsSecurityProperties.CorsProperties corsProps : corsProperties) {
            CorsConfiguration configuration = new CorsConfiguration();
            configuration.setAllowedOrigins(Arrays.asList(corsProps.getAllowedOrigins()));
            configuration.setAllowedMethods(Arrays.asList(corsProps.getAllowedMethods()));
            configuration.setAllowedHeaders(Arrays.asList(corsProps.getAllowedHeaders()));
            configuration.setExposedHeaders(Arrays.asList(corsProps.getExposedHeaders()));
            source.registerCorsConfiguration(corsProps.getPath(), configuration);
        }
        return source;
    }

    @ConditionalOnMissingBean
    @Bean
    SpringAddonsOAuth2AuthorizedClientRepository oAuth2AuthorizedClientRepository(ClientRegistrationRepository clientRegistrationRepository) {
        return new SpringAddonsOAuth2AuthorizedClientRepository(clientRegistrationRepository);
    }

    @ConditionalOnMissingBean
    @Bean
    ClientExpressionInterceptUrlRegistryPostProcessor clientAuthorizePostProcessor() {
        return registry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)registry.anyRequest()).authenticated();
    }

    @ConditionalOnMissingBean
    @Bean
    ClientHttpSecurityPostProcessor clientHttpPostProcessor() {
        return http -> http;
    }

    static class HasClientSecurityMatcher
    extends AnyNestedCondition {
        public HasClientSecurityMatcher() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(name={"com.c4-soft.springaddons.security.client.security-matchers[0]"})
        static class Value2Condition {
            Value2Condition() {
            }
        }

        @ConditionalOnExpression(value="!(T(org.springframework.util.StringUtils).isEmpty('${com.c4-soft.springaddons.security.client.security-matchers:}') && T(org.springframework.util.StringUtils).isEmpty('${com.c4-soft.springaddons.security.client.security-matchers[0]:}'))")
        static class Value1Condition {
            Value1Condition() {
            }
        }
    }
}

