/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config.synchronised;

import com.c4_soft.springaddons.security.oauth2.config.LogoutRequestUriBuilder;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;

public class SpringAddonsOAuth2LogoutSuccessHandler
extends SimpleUrlLogoutSuccessHandler {
    private final LogoutRequestUriBuilder uriBuilder;
    private final ClientRegistrationRepository clientRegistrationRepository;

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        if (authentication instanceof OAuth2AuthenticationToken) {
            OAuth2AuthenticationToken oauth = (OAuth2AuthenticationToken)authentication;
            ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(oauth.getAuthorizedClientRegistrationId());
            return this.uriBuilder.getLogoutRequestUri(clientRegistration, oauth.getName());
        }
        return null;
    }

    @Generated
    public LogoutRequestUriBuilder getUriBuilder() {
        return this.uriBuilder;
    }

    @Generated
    public ClientRegistrationRepository getClientRegistrationRepository() {
        return this.clientRegistrationRepository;
    }

    @Generated
    public String toString() {
        return "SpringAddonsOAuth2LogoutSuccessHandler(uriBuilder=" + this.getUriBuilder() + ", clientRegistrationRepository=" + this.getClientRegistrationRepository() + ")";
    }

    @Generated
    public SpringAddonsOAuth2LogoutSuccessHandler(LogoutRequestUriBuilder uriBuilder, ClientRegistrationRepository clientRegistrationRepository) {
        this.uriBuilder = uriBuilder;
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringAddonsOAuth2LogoutSuccessHandler)) {
            return false;
        }
        SpringAddonsOAuth2LogoutSuccessHandler other = (SpringAddonsOAuth2LogoutSuccessHandler)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LogoutRequestUriBuilder this$uriBuilder = this.getUriBuilder();
        LogoutRequestUriBuilder other$uriBuilder = other.getUriBuilder();
        if (this$uriBuilder == null ? other$uriBuilder != null : !this$uriBuilder.equals(other$uriBuilder)) {
            return false;
        }
        ClientRegistrationRepository this$clientRegistrationRepository = this.getClientRegistrationRepository();
        ClientRegistrationRepository other$clientRegistrationRepository = other.getClientRegistrationRepository();
        return !(this$clientRegistrationRepository == null ? other$clientRegistrationRepository != null : !this$clientRegistrationRepository.equals(other$clientRegistrationRepository));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpringAddonsOAuth2LogoutSuccessHandler;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        LogoutRequestUriBuilder $uriBuilder = this.getUriBuilder();
        result = result * 59 + ($uriBuilder == null ? 43 : $uriBuilder.hashCode());
        ClientRegistrationRepository $clientRegistrationRepository = this.getClientRegistrationRepository();
        result = result * 59 + ($clientRegistrationRepository == null ? 43 : $clientRegistrationRepository.hashCode());
        return result;
    }
}

