/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config.synchronised;

import com.c4_soft.springaddons.security.oauth2.OpenidClaimSet;
import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsSecurityProperties;
import com.c4_soft.springaddons.security.oauth2.config.synchronised.AddonsSecurityBeans;
import com.c4_soft.springaddons.security.oauth2.config.synchronised.OAuth2AuthenticationFactory;
import com.c4_soft.springaddons.security.oauth2.config.synchronised.ResourceServerExpressionInterceptUrlRegistryPostProcessor;
import com.c4_soft.springaddons.security.oauth2.config.synchronised.ResourceServerHttpSecurityPostProcessor;
import com.c4_soft.springaddons.security.oauth2.config.synchronised.ServletConfigurationSupport;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtIssuerAuthenticationManagerResolver;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@ConditionalOnProperty(matchIfMissing=true, prefix="com.c4-soft.springaddons.security", name={"enabled"})
@AutoConfiguration
@EnableWebSecurity
@Import(value={AddonsSecurityBeans.class})
public class AddonsWebSecurityBeans {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AddonsWebSecurityBeans.class);

    @Order(value=0x7FFFFFFF)
    @Bean
    SecurityFilterChain springAddonsResourceServerSecurityFilterChain(HttpSecurity http, ServerProperties serverProperties, SpringAddonsSecurityProperties addonsProperties, ResourceServerExpressionInterceptUrlRegistryPostProcessor authorizePostProcessor, ResourceServerHttpSecurityPostProcessor httpPostProcessor, AuthenticationManagerResolver<HttpServletRequest> authenticationManagerResolver) throws Exception {
        http.oauth2ResourceServer(oauth2 -> oauth2.authenticationManagerResolver(authenticationManagerResolver));
        ServletConfigurationSupport.configureResourceServer((HttpSecurity)http, (ServerProperties)serverProperties, (SpringAddonsSecurityProperties)addonsProperties, (ResourceServerExpressionInterceptUrlRegistryPostProcessor)authorizePostProcessor, (ResourceServerHttpSecurityPostProcessor)httpPostProcessor);
        return (SecurityFilterChain)http.build();
    }

    @ConditionalOnMissingBean
    @Bean
    ResourceServerExpressionInterceptUrlRegistryPostProcessor authorizePostProcessor() {
        return registry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)registry.anyRequest()).authenticated();
    }

    @ConditionalOnMissingBean
    @Bean
    ResourceServerHttpSecurityPostProcessor httpPostProcessor() {
        return httpSecurity -> httpSecurity;
    }

    CorsConfigurationSource corsConfig(SpringAddonsSecurityProperties.CorsProperties[] corsProperties) {
        log.debug("Building default CorsConfigurationSource with: {}", Stream.of(corsProperties).toList());
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        for (SpringAddonsSecurityProperties.CorsProperties corsProps : corsProperties) {
            CorsConfiguration configuration = new CorsConfiguration();
            configuration.setAllowedOrigins(Arrays.asList(corsProps.getAllowedOrigins()));
            configuration.setAllowedMethods(Arrays.asList(corsProps.getAllowedMethods()));
            configuration.setAllowedHeaders(Arrays.asList(corsProps.getAllowedHeaders()));
            configuration.setExposedHeaders(Arrays.asList(corsProps.getExposedHeaders()));
            source.registerCorsConfiguration(corsProps.getPath(), configuration);
        }
        return source;
    }

    @ConditionalOnMissingBean
    @Bean
    Jwt2AuthenticationConverter<? extends AbstractAuthenticationToken> jwtAuthenticationConverter(Converter<Map<String, Object>, Collection<? extends GrantedAuthority>> authoritiesConverter, SpringAddonsSecurityProperties addonsProperties, Optional<OAuth2AuthenticationFactory> authenticationFactory) {
        return jwt -> authenticationFactory.map(af -> af.build(jwt.getTokenValue(), jwt.getClaims())).orElse((AbstractAuthenticationToken)new JwtAuthenticationToken(jwt, (Collection)authoritiesConverter.convert((Object)jwt.getClaims()), new OpenidClaimSet(jwt.getClaims(), addonsProperties.getIssuerProperties((Object)jwt.getIssuer()).getUsernameClaim()).getName()));
    }

    @ConditionalOnMissingBean
    @Bean
    AuthenticationManagerResolver<HttpServletRequest> authenticationManagerResolver(OAuth2ResourceServerProperties auth2ResourceServerProperties, SpringAddonsSecurityProperties addonsProperties, Converter<Jwt, ? extends AbstractAuthenticationToken> jwtAuthenticationConverter) {
        Optional<OAuth2ResourceServerProperties.Jwt> jwtProps = Optional.ofNullable(auth2ResourceServerProperties).map(OAuth2ResourceServerProperties::getJwt);
        Optional.ofNullable(jwtProps.map(OAuth2ResourceServerProperties.Jwt::getIssuerUri)).orElse(jwtProps.map(OAuth2ResourceServerProperties.Jwt::getJwkSetUri)).filter(StringUtils::hasLength).ifPresent(jwtConf -> log.warn("spring.security.oauth2.resourceserver configuration will be ignored in favor of com.c4-soft.springaddons.security"));
        Map<String, AuthenticationManager> jwtManagers = Stream.of(addonsProperties.getIssuers()).collect(Collectors.toMap(issuer -> issuer.getLocation().toString(), issuer -> {
            NimbusJwtDecoder decoder = issuer.getJwkSetUri() != null && StringUtils.hasLength((String)issuer.getJwkSetUri().toString()) ? NimbusJwtDecoder.withJwkSetUri((String)issuer.getJwkSetUri().toString()).build() : NimbusJwtDecoder.withIssuerLocation((String)issuer.getLocation().toString()).build();
            OAuth2TokenValidator defaultValidator = Optional.ofNullable(issuer.getLocation()).map(URI::toString).map(JwtValidators::createDefaultWithIssuer).orElse(JwtValidators.createDefault());
            OAuth2TokenValidator jwtValidator = Optional.ofNullable(issuer.getAudience()).filter(StringUtils::hasText).map(audience -> new JwtClaimValidator("aud", aud -> aud != null && aud.contains(audience))).map(audValidator -> new DelegatingOAuth2TokenValidator(List.of(defaultValidator, audValidator))).orElse(defaultValidator);
            decoder.setJwtValidator(jwtValidator);
            JwtAuthenticationProvider provider = new JwtAuthenticationProvider((JwtDecoder)decoder);
            provider.setJwtAuthenticationConverter(jwtAuthenticationConverter);
            return arg_0 -> ((JwtAuthenticationProvider)provider).authenticate(arg_0);
        }));
        log.debug("Building default JwtIssuerAuthenticationManagerResolver with: ", (Object)auth2ResourceServerProperties.getJwt(), Stream.of(addonsProperties.getIssuers()).toList());
        return new JwtIssuerAuthenticationManagerResolver(jwtManagers::get);
    }

    public static interface Jwt2AuthenticationConverter<T extends AbstractAuthenticationToken>
    extends Converter<Jwt, T> {
    }
}

