/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.mockmvc;

import com.c4_soft.springaddons.security.oauth2.config.OAuth2AuthoritiesConverter;
import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsSecurityProperties;
import com.c4_soft.springaddons.security.oauth2.config.synchronised.ExpressionInterceptUrlRegistryPostProcessor;
import com.c4_soft.springaddons.security.oauth2.config.synchronised.ResourceServerHttpSecurityPostProcessor;
import com.c4_soft.springaddons.security.oauth2.test.mockmvc.MockMvcProperties;
import com.c4_soft.springaddons.security.oauth2.test.mockmvc.MockMvcSupport;
import com.c4_soft.springaddons.test.support.web.SerializationHelper;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import org.mockito.Mockito;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.XorCsrfTokenRequestAttributeHandler;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@AutoConfiguration
@Import(value={MockMvcProperties.class})
public class AddonsWebmvcTestConf {
    @MockBean
    JwtDecoder jwtDecoder;
    @MockBean
    AuthenticationManagerResolver<HttpServletRequest> jwtIssuerAuthenticationManagerResolver;
    @MockBean
    OpaqueTokenIntrospector introspector;
    @MockBean
    OAuth2AuthorizedClientService oAuth2AuthorizedClientService;

    @ConditionalOnMissingBean
    @Bean
    InMemoryClientRegistrationRepository clientRegistrationRepository() {
        InMemoryClientRegistrationRepository clientRegistrationRepository = (InMemoryClientRegistrationRepository)Mockito.mock(InMemoryClientRegistrationRepository.class);
        Mockito.when((Object)clientRegistrationRepository.iterator()).thenReturn(new ArrayList().iterator());
        Mockito.when((Object)clientRegistrationRepository.spliterator()).thenReturn(new ArrayList().spliterator());
        return clientRegistrationRepository;
    }

    @Bean
    SerializationHelper serializationHelper(ObjectFactory<HttpMessageConverters> messageConverters) {
        return new SerializationHelper(messageConverters);
    }

    @Bean
    @Scope(value="prototype")
    MockMvcSupport mockMvcSupport(MockMvc mockMvc, SerializationHelper serializationHelper, MockMvcProperties mockMvcProperties, ServerProperties serverProperties, SpringAddonsSecurityProperties addonsProperties) {
        return new MockMvcSupport(mockMvc, serializationHelper, mockMvcProperties, serverProperties, addonsProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    OAuth2AuthoritiesConverter claimSet2AuthoritiesConverter() {
        return (OAuth2AuthoritiesConverter)Mockito.mock(OAuth2AuthoritiesConverter.class);
    }

    @ConditionalOnMissingBean
    @Bean
    SecurityFilterChain resourceServerSecurityFilterChain(HttpSecurity http, ServerProperties serverProperties, SpringAddonsSecurityProperties addonsProperties, ExpressionInterceptUrlRegistryPostProcessor authorizePostProcessor, ResourceServerHttpSecurityPostProcessor httpPostProcessor, CorsConfigurationSource corsConfigurationSource) throws Exception {
        if (addonsProperties.getCors().length > 0) {
            http.cors(cors -> cors.configurationSource(corsConfigurationSource));
        } else {
            http.cors(cors -> cors.disable());
        }
        switch (addonsProperties.getCsrf()) {
            case DISABLE: {
                http.csrf(csrf -> csrf.disable());
                break;
            }
            case DEFAULT: {
                if (addonsProperties.isStatlessSessions()) {
                    http.csrf(csrf -> csrf.disable());
                    break;
                }
                http.csrf(Customizer.withDefaults());
                break;
            }
            case SESSION: {
                http.csrf(Customizer.withDefaults());
                break;
            }
            case COOKIE_HTTP_ONLY: {
                http.csrf(csrf -> csrf.csrfTokenRepository((CsrfTokenRepository)new CookieCsrfTokenRepository()));
                break;
            }
            case COOKIE_ACCESSIBLE_FROM_JS: {
                http.csrf(csrf -> csrf.csrfTokenRepository((CsrfTokenRepository)CookieCsrfTokenRepository.withHttpOnlyFalse()).csrfTokenRequestHandler((arg_0, arg_1, arg_2) -> ((XorCsrfTokenRequestAttributeHandler)new XorCsrfTokenRequestAttributeHandler()).handle(arg_0, arg_1, arg_2)));
            }
        }
        if (addonsProperties.isStatlessSessions()) {
            http.sessionManagement(sessionManagement -> sessionManagement.sessionCreationPolicy(SessionCreationPolicy.STATELESS));
        }
        if (!addonsProperties.isRedirectToLoginIfUnauthorizedOnRestrictedContent()) {
            http.exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint((request, response, authException) -> {
                response.addHeader("WWW-Authenticate", "Basic realm=\"Restricted Content\"");
                response.sendError(HttpStatus.UNAUTHORIZED.value(), HttpStatus.UNAUTHORIZED.getReasonPhrase());
            }));
        }
        if (serverProperties.getSsl() != null && serverProperties.getSsl().isEnabled()) {
            http.requiresChannel(channel -> ((ChannelSecurityConfigurer.RequiresChannelUrl)channel.anyRequest()).requiresSecure());
        }
        http.authorizeHttpRequests(authorizeHttpRequests -> authorizePostProcessor.authorizeHttpRequests(((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeHttpRequests.requestMatchers(addonsProperties.getPermitAll())).permitAll()));
        return (SecurityFilterChain)httpPostProcessor.process(http).build();
    }

    @ConditionalOnMissingBean
    @Bean
    ExpressionInterceptUrlRegistryPostProcessor authorizePostProcessor() {
        return registry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)registry.anyRequest()).authenticated();
    }

    @ConditionalOnMissingBean
    @Bean
    ResourceServerHttpSecurityPostProcessor httpPostProcessor() {
        return httpSecurity -> httpSecurity;
    }

    @ConditionalOnMissingBean
    @Bean
    CorsConfigurationSource corsConfigurationSource(SpringAddonsSecurityProperties addonsProperties) {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        for (SpringAddonsSecurityProperties.CorsProperties corsProps : addonsProperties.getCors()) {
            CorsConfiguration configuration = new CorsConfiguration();
            configuration.setAllowedOrigins(Arrays.asList(corsProps.getAllowedOrigins()));
            configuration.setAllowedMethods(Arrays.asList(corsProps.getAllowedMethods()));
            configuration.setAllowedHeaders(Arrays.asList(corsProps.getAllowedHeaders()));
            configuration.setExposedHeaders(Arrays.asList(corsProps.getExposedHeaders()));
            source.registerCorsConfiguration(corsProps.getPath(), configuration);
        }
        return source;
    }
}

