/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.oidc;

import com.c4_soft.springaddons.security.oauth2.oidc.OidcToken;
import java.util.Collection;
import java.util.Objects;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class OidcAuthentication
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = -2827891205034221389L;
    private final OidcToken token;
    private final String authorizationHeader;

    public OidcAuthentication(OidcToken token, Collection<? extends GrantedAuthority> authorities, String bearerString) {
        super(authorities);
        this.token = token;
        this.setAuthenticated(true);
        this.setDetails(token);
        this.authorizationHeader = String.format("Bearer %s", bearerString);
    }

    public String getAuthorizationHeader() {
        return this.authorizationHeader;
    }

    public OidcToken getToken() {
        return this.token;
    }

    public OidcToken getCredentials() {
        return this.getToken();
    }

    public OidcToken getPrincipal() {
        return this.getToken();
    }

    public OidcToken getDetails() {
        return this.getToken();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + Objects.hash(this.token);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof OidcAuthentication)) {
            return false;
        }
        OidcAuthentication other = (OidcAuthentication)((Object)obj);
        return Objects.equals(this.token, other.token);
    }
}

