/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.oidc;

import com.c4_soft.springaddons.security.oauth2.ReactiveJwt2GrantedAuthoritiesConverter;
import com.c4_soft.springaddons.security.oauth2.oidc.OidcAuthentication;
import com.c4_soft.springaddons.security.oauth2.oidc.OidcToken;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveJwt2OidcAuthenticationConverter
implements Converter<Jwt, Mono<OidcAuthentication>> {
    private final ReactiveJwt2GrantedAuthoritiesConverter authoritiesConverter;

    @Autowired
    public ReactiveJwt2OidcAuthenticationConverter(ReactiveJwt2GrantedAuthoritiesConverter authoritiesConverter) {
        this.authoritiesConverter = authoritiesConverter;
    }

    public Mono<OidcAuthentication> convert(Jwt jwt) {
        return ((Flux)this.authoritiesConverter.convert(jwt)).collectList().map(authorities -> new OidcAuthentication(new OidcToken(jwt.getClaims()), (Collection<? extends GrantedAuthority>)authorities, jwt.getTokenValue()));
    }
}

