/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config;

import com.c4_soft.springaddons.security.oauth2.ReactiveJwt2GrantedAuthoritiesConverter;
import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsSecurityProperties;
import com.nimbusds.jose.shaded.json.JSONArray;
import java.util.Optional;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import reactor.core.publisher.Flux;

public class Auth0ReactiveJwt2GrantedAuthoritiesConverter
implements ReactiveJwt2GrantedAuthoritiesConverter {
    private final SpringAddonsSecurityProperties securityProperties;

    public Flux<GrantedAuthority> convert(Jwt jwt) {
        JSONArray roles = Optional.ofNullable((JSONArray)jwt.getClaims().get(this.securityProperties.getAuth0().getRolesClaim())).orElse(new JSONArray());
        return Flux.fromStream(roles.stream().map(Object::toString).map(SimpleGrantedAuthority::new));
    }

    public Auth0ReactiveJwt2GrantedAuthoritiesConverter(SpringAddonsSecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }
}

