/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config;

import com.c4_soft.springaddons.security.oauth2.ReactiveJwt2GrantedAuthoritiesConverter;
import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsSecurityProperties;
import com.nimbusds.jose.shaded.json.JSONArray;
import com.nimbusds.jose.shaded.json.JSONObject;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import reactor.core.publisher.Flux;

public class KeycloakReactiveJwt2GrantedAuthoritiesConverter
implements ReactiveJwt2GrantedAuthoritiesConverter {
    private final SpringAddonsSecurityProperties securityProperties;

    public Flux<GrantedAuthority> convert(Jwt jwt) {
        JSONArray realmRoles = Optional.ofNullable((JSONObject)jwt.getClaims().get("realm_access")).flatMap(realmAccess -> Optional.ofNullable((JSONArray)realmAccess.get((Object)"roles"))).orElse(new JSONArray());
        JSONArray clientRoles = Optional.ofNullable((JSONObject)jwt.getClaims().get("resource_access")).flatMap(resourceAccess -> Optional.ofNullable((JSONObject)resourceAccess.get((Object)this.securityProperties.getKeycloak().getClientId()))).flatMap(clientResourceAccess -> Optional.ofNullable((JSONArray)clientResourceAccess.get((Object)"roles"))).orElse(new JSONArray());
        return Flux.fromStream(Stream.concat(realmRoles.stream(), clientRoles.stream()).map(Object::toString).map(r -> this.securityProperties.getAuthoritiesPrefix() + (this.securityProperties.isUppercaseAuthorities() ? r.toUpperCase() : r)).map(SimpleGrantedAuthority::new));
    }

    public KeycloakReactiveJwt2GrantedAuthoritiesConverter(SpringAddonsSecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }
}

