/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config;

import com.c4_soft.springaddons.security.oauth2.ReactiveJwt2AuthenticationConverter;
import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsSecurityProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.security.web.server.context.NoOpServerSecurityContextRepository;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;

public class OidcReactiveApiSecurityConfig {
    private final ReactiveJwt2AuthenticationConverter<? extends AbstractAuthenticationToken> authenticationConverter;
    private final SpringAddonsSecurityProperties securityProperties;
    @Value(value="${server.ssl.enabled:false}")
    private final boolean isSslEnabled;

    @ConditionalOnMissingBean
    @Bean
    public SecurityWebFilterChain springSecurityFilterChain(ServerHttpSecurity http, ServerAccessDeniedHandler accessDeniedHandler) {
        http.oauth2ResourceServer().jwt().jwtAuthenticationConverter(this.authenticationConverter);
        http.anonymous().and().cors().and().csrf().disable().securityContextRepository((ServerSecurityContextRepository)NoOpServerSecurityContextRepository.getInstance()).exceptionHandling().accessDeniedHandler(accessDeniedHandler);
        this.authorizeRequests(((ServerHttpSecurity.AuthorizeExchangeSpec.Access)http.authorizeExchange().pathMatchers(this.securityProperties.getPermitAll())).permitAll());
        if (this.isSslEnabled) {
            http.redirectToHttps();
        }
        return http.build();
    }

    protected ServerHttpSecurity.AuthorizeExchangeSpec authorizeRequests(ServerHttpSecurity.AuthorizeExchangeSpec spec) {
        return spec.anyExchange().authenticated();
    }

    public ReactiveJwt2AuthenticationConverter<? extends AbstractAuthenticationToken> getAuthenticationConverter() {
        return this.authenticationConverter;
    }

    public SpringAddonsSecurityProperties getSecurityProperties() {
        return this.securityProperties;
    }

    public boolean isSslEnabled() {
        return this.isSslEnabled;
    }

    public OidcReactiveApiSecurityConfig(ReactiveJwt2AuthenticationConverter<? extends AbstractAuthenticationToken> authenticationConverter, SpringAddonsSecurityProperties securityProperties, boolean isSslEnabled) {
        this.authenticationConverter = authenticationConverter;
        this.securityProperties = securityProperties;
        this.isSslEnabled = isSslEnabled;
    }
}

