/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config;

import com.c4_soft.springaddons.security.oauth2.SynchronizedJwt2AuthenticationConverter;
import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsSecurityProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;

public class OidcServletApiSecurityConfig
extends WebSecurityConfigurerAdapter {
    private final SynchronizedJwt2AuthenticationConverter<? extends AbstractAuthenticationToken> authenticationConverter;
    private final SpringAddonsSecurityProperties securityProperties;
    @Value(value="${server.ssl.enabled:false}")
    private final boolean isSslEnabled;

    protected void configure(HttpSecurity http) throws Exception {
        http.oauth2ResourceServer().jwt().jwtAuthenticationConverter(this.authenticationConverter);
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.anonymous().and()).cors().and()).csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).exceptionHandling().authenticationEntryPoint((request, response, authException) -> {
            response.addHeader("WWW-Authenticate", "Basic realm=\"Restricted Content\"");
            response.sendError(HttpStatus.UNAUTHORIZED.value(), HttpStatus.UNAUTHORIZED.getReasonPhrase());
        });
        this.authorizeRequests(((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(this.securityProperties.getPermitAll())).permitAll());
        if (this.isSslEnabled) {
            ((ChannelSecurityConfigurer.RequiresChannelUrl)http.requiresChannel().anyRequest()).requiresSecure();
        } else {
            ((ChannelSecurityConfigurer.RequiresChannelUrl)http.requiresChannel().anyRequest()).requiresInsecure();
        }
    }

    protected ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry authorizeRequests(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry registry) {
        return ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.anyRequest()).authenticated();
    }

    public SynchronizedJwt2AuthenticationConverter<? extends AbstractAuthenticationToken> getAuthenticationConverter() {
        return this.authenticationConverter;
    }

    public SpringAddonsSecurityProperties getSecurityProperties() {
        return this.securityProperties;
    }

    public boolean isSslEnabled() {
        return this.isSslEnabled;
    }

    public OidcServletApiSecurityConfig(SynchronizedJwt2AuthenticationConverter<? extends AbstractAuthenticationToken> authenticationConverter, SpringAddonsSecurityProperties securityProperties, boolean isSslEnabled) {
        this.authenticationConverter = authenticationConverter;
        this.securityProperties = securityProperties;
        this.isSslEnabled = isSslEnabled;
    }
}

