/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config;

import com.c4_soft.springaddons.security.oauth2.SynchronizedJwt2AuthenticationConverter;
import com.c4_soft.springaddons.security.oauth2.SynchronizedJwt2GrantedAuthoritiesConverter;
import com.c4_soft.springaddons.security.oauth2.SynchronizedJwt2OidcTokenConverter;
import com.c4_soft.springaddons.security.oauth2.config.Auth0SynchronizedJwt2GrantedAuthoritiesConverter;
import com.c4_soft.springaddons.security.oauth2.config.KeycloakSynchronizedJwt2GrantedAuthoritiesConverter;
import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsSecurityProperties;
import com.c4_soft.springaddons.security.oauth2.oidc.OidcToken;
import com.c4_soft.springaddons.security.oauth2.oidc.SynchronizedJwt2OidcAuthenticationConverter;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoders;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

public class ServletSecurityBeans {
    private final String issuerUri;
    private final SpringAddonsSecurityProperties securityProperties;

    public ServletSecurityBeans(@Value(value="${spring.security.oauth2.resourceserver.jwt.issuer-uri}") String issuerUri, SpringAddonsSecurityProperties securityProperties) {
        this.issuerUri = issuerUri;
        this.securityProperties = securityProperties;
    }

    @ConditionalOnMissingBean
    @Bean
    public <T extends OidcToken> SynchronizedJwt2AuthenticationConverter<? extends AbstractAuthenticationToken> authenticationConverter(SynchronizedJwt2GrantedAuthoritiesConverter authoritiesConverter, SynchronizedJwt2OidcTokenConverter<T> tokenConverter) {
        return new SynchronizedJwt2OidcAuthenticationConverter<T>(authoritiesConverter, tokenConverter);
    }

    @ConditionalOnMissingBean
    @Bean
    public SynchronizedJwt2GrantedAuthoritiesConverter authoritiesConverter() {
        return this.securityProperties.getKeycloak() != null && StringUtils.hasLength((String)this.securityProperties.getKeycloak().getClientId()) ? new KeycloakSynchronizedJwt2GrantedAuthoritiesConverter(this.securityProperties) : new Auth0SynchronizedJwt2GrantedAuthoritiesConverter(this.securityProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    public SynchronizedJwt2OidcTokenConverter<OidcToken> tokenConverter() {
        return jwt -> new OidcToken(jwt.getClaims());
    }

    @ConditionalOnMissingBean
    @Bean
    public JwtDecoder jwtDecoder() {
        return JwtDecoders.fromOidcIssuerLocation((String)this.issuerUri);
    }

    @ConditionalOnMissingBean
    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(Arrays.asList(this.securityProperties.getCors().getAllowedOrigins()));
        configuration.setAllowedMethods(Arrays.asList(this.securityProperties.getCors().getAllowedMethods()));
        configuration.setAllowedHeaders(Arrays.asList(this.securityProperties.getCors().getAllowedHeaders()));
        configuration.setExposedHeaders(Arrays.asList(this.securityProperties.getCors().getExposedHeaders()));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        for (String p : this.securityProperties.getCors().getPath()) {
            source.registerCorsConfiguration(p, configuration);
        }
        return source;
    }
}

