/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config;

import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="com.c4-soft.springaddons.security")
public class SpringAddonsSecurityProperties {
    private KeycloakProperties keycloak;
    private Auth0Properties auth0;
    private CorsProperties cors;
    private String authoritiesPrefix = "";
    private boolean uppercaseAuthorities = false;
    private String[] permitAll = new String[]{"/actuator/**", "/v3/api-docs/**", "/swagger-ui/**", "/swagger-ui.html", "/webjars/swagger-ui/**", "/favicon.ico"};

    public KeycloakProperties getKeycloak() {
        return this.keycloak;
    }

    public Auth0Properties getAuth0() {
        return this.auth0;
    }

    public CorsProperties getCors() {
        return this.cors;
    }

    public String getAuthoritiesPrefix() {
        return this.authoritiesPrefix;
    }

    public boolean isUppercaseAuthorities() {
        return this.uppercaseAuthorities;
    }

    public String[] getPermitAll() {
        return this.permitAll;
    }

    public void setKeycloak(KeycloakProperties keycloak) {
        this.keycloak = keycloak;
    }

    public void setAuth0(Auth0Properties auth0) {
        this.auth0 = auth0;
    }

    public void setCors(CorsProperties cors) {
        this.cors = cors;
    }

    public void setAuthoritiesPrefix(String authoritiesPrefix) {
        this.authoritiesPrefix = authoritiesPrefix;
    }

    public void setUppercaseAuthorities(boolean uppercaseAuthorities) {
        this.uppercaseAuthorities = uppercaseAuthorities;
    }

    public void setPermitAll(String[] permitAll) {
        this.permitAll = permitAll;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringAddonsSecurityProperties)) {
            return false;
        }
        SpringAddonsSecurityProperties other = (SpringAddonsSecurityProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUppercaseAuthorities() != other.isUppercaseAuthorities()) {
            return false;
        }
        KeycloakProperties this$keycloak = this.getKeycloak();
        KeycloakProperties other$keycloak = other.getKeycloak();
        if (this$keycloak == null ? other$keycloak != null : !((Object)this$keycloak).equals(other$keycloak)) {
            return false;
        }
        Auth0Properties this$auth0 = this.getAuth0();
        Auth0Properties other$auth0 = other.getAuth0();
        if (this$auth0 == null ? other$auth0 != null : !((Object)this$auth0).equals(other$auth0)) {
            return false;
        }
        CorsProperties this$cors = this.getCors();
        CorsProperties other$cors = other.getCors();
        if (this$cors == null ? other$cors != null : !((Object)this$cors).equals(other$cors)) {
            return false;
        }
        String this$authoritiesPrefix = this.getAuthoritiesPrefix();
        String other$authoritiesPrefix = other.getAuthoritiesPrefix();
        if (this$authoritiesPrefix == null ? other$authoritiesPrefix != null : !this$authoritiesPrefix.equals(other$authoritiesPrefix)) {
            return false;
        }
        return Arrays.deepEquals(this.getPermitAll(), other.getPermitAll());
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpringAddonsSecurityProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUppercaseAuthorities() ? 79 : 97);
        KeycloakProperties $keycloak = this.getKeycloak();
        result = result * 59 + ($keycloak == null ? 43 : ((Object)$keycloak).hashCode());
        Auth0Properties $auth0 = this.getAuth0();
        result = result * 59 + ($auth0 == null ? 43 : ((Object)$auth0).hashCode());
        CorsProperties $cors = this.getCors();
        result = result * 59 + ($cors == null ? 43 : ((Object)$cors).hashCode());
        String $authoritiesPrefix = this.getAuthoritiesPrefix();
        result = result * 59 + ($authoritiesPrefix == null ? 43 : $authoritiesPrefix.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPermitAll());
        return result;
    }

    public String toString() {
        return "SpringAddonsSecurityProperties(keycloak=" + this.getKeycloak() + ", auth0=" + this.getAuth0() + ", cors=" + this.getCors() + ", authoritiesPrefix=" + this.getAuthoritiesPrefix() + ", uppercaseAuthorities=" + this.isUppercaseAuthorities() + ", permitAll=" + Arrays.deepToString(this.getPermitAll()) + ")";
    }

    public static class KeycloakProperties {
        private String clientId;

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeycloakProperties)) {
                return false;
            }
            KeycloakProperties other = (KeycloakProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$clientId = this.getClientId();
            String other$clientId = other.getClientId();
            return !(this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof KeycloakProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $clientId = this.getClientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            return result;
        }

        public String toString() {
            return "SpringAddonsSecurityProperties.KeycloakProperties(clientId=" + this.getClientId() + ")";
        }
    }

    public static class Auth0Properties {
        private String rolesClaim = "https://manage.auth0.com/roles";

        public String getRolesClaim() {
            return this.rolesClaim;
        }

        public void setRolesClaim(String rolesClaim) {
            this.rolesClaim = rolesClaim;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Auth0Properties)) {
                return false;
            }
            Auth0Properties other = (Auth0Properties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$rolesClaim = this.getRolesClaim();
            String other$rolesClaim = other.getRolesClaim();
            return !(this$rolesClaim == null ? other$rolesClaim != null : !this$rolesClaim.equals(other$rolesClaim));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Auth0Properties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $rolesClaim = this.getRolesClaim();
            result = result * 59 + ($rolesClaim == null ? 43 : $rolesClaim.hashCode());
            return result;
        }

        public String toString() {
            return "SpringAddonsSecurityProperties.Auth0Properties(rolesClaim=" + this.getRolesClaim() + ")";
        }
    }

    public static class CorsProperties {
        private String[] path = new String[]{"/**"};
        private String[] allowedOrigins = new String[]{"*"};
        private String[] allowedMethods = new String[]{"*"};
        private String[] allowedHeaders = new String[]{"*"};
        private String[] exposedHeaders = new String[]{"*"};

        public String[] getPath() {
            return this.path;
        }

        public String[] getAllowedOrigins() {
            return this.allowedOrigins;
        }

        public String[] getAllowedMethods() {
            return this.allowedMethods;
        }

        public String[] getAllowedHeaders() {
            return this.allowedHeaders;
        }

        public String[] getExposedHeaders() {
            return this.exposedHeaders;
        }

        public void setPath(String[] path) {
            this.path = path;
        }

        public void setAllowedOrigins(String[] allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
        }

        public void setAllowedMethods(String[] allowedMethods) {
            this.allowedMethods = allowedMethods;
        }

        public void setAllowedHeaders(String[] allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
        }

        public void setExposedHeaders(String[] exposedHeaders) {
            this.exposedHeaders = exposedHeaders;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CorsProperties)) {
                return false;
            }
            CorsProperties other = (CorsProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getPath(), other.getPath())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAllowedOrigins(), other.getAllowedOrigins())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAllowedMethods(), other.getAllowedMethods())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAllowedHeaders(), other.getAllowedHeaders())) {
                return false;
            }
            return Arrays.deepEquals(this.getExposedHeaders(), other.getExposedHeaders());
        }

        protected boolean canEqual(Object other) {
            return other instanceof CorsProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getPath());
            result = result * 59 + Arrays.deepHashCode(this.getAllowedOrigins());
            result = result * 59 + Arrays.deepHashCode(this.getAllowedMethods());
            result = result * 59 + Arrays.deepHashCode(this.getAllowedHeaders());
            result = result * 59 + Arrays.deepHashCode(this.getExposedHeaders());
            return result;
        }

        public String toString() {
            return "SpringAddonsSecurityProperties.CorsProperties(path=" + Arrays.deepToString(this.getPath()) + ", allowedOrigins=" + Arrays.deepToString(this.getAllowedOrigins()) + ", allowedMethods=" + Arrays.deepToString(this.getAllowedMethods()) + ", allowedHeaders=" + Arrays.deepToString(this.getAllowedHeaders()) + ", exposedHeaders=" + Arrays.deepToString(this.getExposedHeaders()) + ")";
        }
    }
}

