/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config;

import com.nimbusds.jose.shaded.json.JSONArray;
import com.nimbusds.jose.shaded.json.JSONObject;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

@Configuration
@ConfigurationProperties(prefix="com.c4-soft.springaddons.security")
public class SpringAddonsSecurityProperties {
    private String[] authoritiesClaims = new String[]{"realm_access.roles"};
    private String authoritiesPrefix = "";
    private boolean authoritiesUppercase = false;
    private CorsProperties[] cors = new CorsProperties[]{new CorsProperties()};
    private boolean anonymousEnabled = true;
    private boolean csrfEnabled = false;
    private String[] permitAll = new String[]{"/actuator/**", "/v3/api-docs/**", "/swagger-ui/**", "/swagger-ui.html", "/webjars/swagger-ui/**", "/favicon.ico"};
    private boolean redirectToLoginIfUnauthorizedOnRestrictedContent = false;
    private boolean statlessSessions = true;
    private String[] authorizationServerLocations = new String[0];
    private Charset jsonTokenStringCharset = StandardCharsets.UTF_8;

    public Stream<GrantedAuthority> getAuthorities(Map<String, Object> claims) {
        return Stream.of(this.authoritiesClaims).flatMap(rolesPath -> SpringAddonsSecurityProperties.getRoles(claims, rolesPath)).map(r -> this.authoritiesPrefix + (this.authoritiesUppercase ? r.toUpperCase() : r)).map(r -> new SimpleGrantedAuthority(r));
    }

    private static Stream<String> getRoles(Map<String, Object> claims, String rolesPath) {
        String[] claimsToWalk = rolesPath.split("\\.");
        int i = 0;
        Optional<Map<String, Object>> obj = Optional.of(claims);
        while (i++ < claimsToWalk.length) {
            String claimName = claimsToWalk[i - 1];
            if (i == claimsToWalk.length) {
                return obj.map(o -> (JSONArray)o.get(claimName)).orElse(new JSONArray()).stream().map(Object::toString);
            }
            obj = obj.map(o -> (JSONObject)o.get(claimName));
        }
        return Stream.empty();
    }

    @Generated
    public SpringAddonsSecurityProperties() {
    }

    @Generated
    public String[] getAuthoritiesClaims() {
        return this.authoritiesClaims;
    }

    @Generated
    public String getAuthoritiesPrefix() {
        return this.authoritiesPrefix;
    }

    @Generated
    public boolean isAuthoritiesUppercase() {
        return this.authoritiesUppercase;
    }

    @Generated
    public CorsProperties[] getCors() {
        return this.cors;
    }

    @Generated
    public boolean isAnonymousEnabled() {
        return this.anonymousEnabled;
    }

    @Generated
    public boolean isCsrfEnabled() {
        return this.csrfEnabled;
    }

    @Generated
    public String[] getPermitAll() {
        return this.permitAll;
    }

    @Generated
    public boolean isRedirectToLoginIfUnauthorizedOnRestrictedContent() {
        return this.redirectToLoginIfUnauthorizedOnRestrictedContent;
    }

    @Generated
    public boolean isStatlessSessions() {
        return this.statlessSessions;
    }

    @Generated
    public String[] getAuthorizationServerLocations() {
        return this.authorizationServerLocations;
    }

    @Generated
    public Charset getJsonTokenStringCharset() {
        return this.jsonTokenStringCharset;
    }

    @Generated
    public void setAuthoritiesClaims(String[] authoritiesClaims) {
        this.authoritiesClaims = authoritiesClaims;
    }

    @Generated
    public void setAuthoritiesPrefix(String authoritiesPrefix) {
        this.authoritiesPrefix = authoritiesPrefix;
    }

    @Generated
    public void setAuthoritiesUppercase(boolean authoritiesUppercase) {
        this.authoritiesUppercase = authoritiesUppercase;
    }

    @Generated
    public void setCors(CorsProperties[] cors) {
        this.cors = cors;
    }

    @Generated
    public void setAnonymousEnabled(boolean anonymousEnabled) {
        this.anonymousEnabled = anonymousEnabled;
    }

    @Generated
    public void setCsrfEnabled(boolean csrfEnabled) {
        this.csrfEnabled = csrfEnabled;
    }

    @Generated
    public void setPermitAll(String[] permitAll) {
        this.permitAll = permitAll;
    }

    @Generated
    public void setRedirectToLoginIfUnauthorizedOnRestrictedContent(boolean redirectToLoginIfUnauthorizedOnRestrictedContent) {
        this.redirectToLoginIfUnauthorizedOnRestrictedContent = redirectToLoginIfUnauthorizedOnRestrictedContent;
    }

    @Generated
    public void setStatlessSessions(boolean statlessSessions) {
        this.statlessSessions = statlessSessions;
    }

    @Generated
    public void setAuthorizationServerLocations(String[] authorizationServerLocations) {
        this.authorizationServerLocations = authorizationServerLocations;
    }

    @Generated
    public void setJsonTokenStringCharset(Charset jsonTokenStringCharset) {
        this.jsonTokenStringCharset = jsonTokenStringCharset;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringAddonsSecurityProperties)) {
            return false;
        }
        SpringAddonsSecurityProperties other = (SpringAddonsSecurityProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAuthoritiesUppercase() != other.isAuthoritiesUppercase()) {
            return false;
        }
        if (this.isAnonymousEnabled() != other.isAnonymousEnabled()) {
            return false;
        }
        if (this.isCsrfEnabled() != other.isCsrfEnabled()) {
            return false;
        }
        if (this.isRedirectToLoginIfUnauthorizedOnRestrictedContent() != other.isRedirectToLoginIfUnauthorizedOnRestrictedContent()) {
            return false;
        }
        if (this.isStatlessSessions() != other.isStatlessSessions()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAuthoritiesClaims(), other.getAuthoritiesClaims())) {
            return false;
        }
        String this$authoritiesPrefix = this.getAuthoritiesPrefix();
        String other$authoritiesPrefix = other.getAuthoritiesPrefix();
        if (this$authoritiesPrefix == null ? other$authoritiesPrefix != null : !this$authoritiesPrefix.equals(other$authoritiesPrefix)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCors(), other.getCors())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPermitAll(), other.getPermitAll())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAuthorizationServerLocations(), other.getAuthorizationServerLocations())) {
            return false;
        }
        Charset this$jsonTokenStringCharset = this.getJsonTokenStringCharset();
        Charset other$jsonTokenStringCharset = other.getJsonTokenStringCharset();
        return !(this$jsonTokenStringCharset == null ? other$jsonTokenStringCharset != null : !((Object)this$jsonTokenStringCharset).equals(other$jsonTokenStringCharset));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpringAddonsSecurityProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAuthoritiesUppercase() ? 79 : 97);
        result = result * 59 + (this.isAnonymousEnabled() ? 79 : 97);
        result = result * 59 + (this.isCsrfEnabled() ? 79 : 97);
        result = result * 59 + (this.isRedirectToLoginIfUnauthorizedOnRestrictedContent() ? 79 : 97);
        result = result * 59 + (this.isStatlessSessions() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getAuthoritiesClaims());
        String $authoritiesPrefix = this.getAuthoritiesPrefix();
        result = result * 59 + ($authoritiesPrefix == null ? 43 : $authoritiesPrefix.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getCors());
        result = result * 59 + Arrays.deepHashCode(this.getPermitAll());
        result = result * 59 + Arrays.deepHashCode(this.getAuthorizationServerLocations());
        Charset $jsonTokenStringCharset = this.getJsonTokenStringCharset();
        result = result * 59 + ($jsonTokenStringCharset == null ? 43 : ((Object)$jsonTokenStringCharset).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SpringAddonsSecurityProperties(authoritiesClaims=" + Arrays.deepToString(this.getAuthoritiesClaims()) + ", authoritiesPrefix=" + this.getAuthoritiesPrefix() + ", authoritiesUppercase=" + this.isAuthoritiesUppercase() + ", cors=" + Arrays.deepToString(this.getCors()) + ", anonymousEnabled=" + this.isAnonymousEnabled() + ", csrfEnabled=" + this.isCsrfEnabled() + ", permitAll=" + Arrays.deepToString(this.getPermitAll()) + ", redirectToLoginIfUnauthorizedOnRestrictedContent=" + this.isRedirectToLoginIfUnauthorizedOnRestrictedContent() + ", statlessSessions=" + this.isStatlessSessions() + ", authorizationServerLocations=" + Arrays.deepToString(this.getAuthorizationServerLocations()) + ", jsonTokenStringCharset=" + this.getJsonTokenStringCharset() + ")";
    }

    public static class CorsProperties {
        private String path = "/**";
        private String[] allowedOrigins = new String[]{"*"};
        private String[] allowedMethods = new String[]{"*"};
        private String[] allowedHeaders = new String[]{"*"};
        private String[] exposedHeaders = new String[]{"*"};

        @Generated
        public CorsProperties() {
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public String[] getAllowedOrigins() {
            return this.allowedOrigins;
        }

        @Generated
        public String[] getAllowedMethods() {
            return this.allowedMethods;
        }

        @Generated
        public String[] getAllowedHeaders() {
            return this.allowedHeaders;
        }

        @Generated
        public String[] getExposedHeaders() {
            return this.exposedHeaders;
        }

        @Generated
        public void setPath(String path) {
            this.path = path;
        }

        @Generated
        public void setAllowedOrigins(String[] allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
        }

        @Generated
        public void setAllowedMethods(String[] allowedMethods) {
            this.allowedMethods = allowedMethods;
        }

        @Generated
        public void setAllowedHeaders(String[] allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
        }

        @Generated
        public void setExposedHeaders(String[] exposedHeaders) {
            this.exposedHeaders = exposedHeaders;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CorsProperties)) {
                return false;
            }
            CorsProperties other = (CorsProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAllowedOrigins(), other.getAllowedOrigins())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAllowedMethods(), other.getAllowedMethods())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAllowedHeaders(), other.getAllowedHeaders())) {
                return false;
            }
            return Arrays.deepEquals(this.getExposedHeaders(), other.getExposedHeaders());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CorsProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getAllowedOrigins());
            result = result * 59 + Arrays.deepHashCode(this.getAllowedMethods());
            result = result * 59 + Arrays.deepHashCode(this.getAllowedHeaders());
            result = result * 59 + Arrays.deepHashCode(this.getExposedHeaders());
            return result;
        }

        @Generated
        public String toString() {
            return "SpringAddonsSecurityProperties.CorsProperties(path=" + this.getPath() + ", allowedOrigins=" + Arrays.deepToString(this.getAllowedOrigins()) + ", allowedMethods=" + Arrays.deepToString(this.getAllowedMethods()) + ", allowedHeaders=" + Arrays.deepToString(this.getAllowedHeaders()) + ", exposedHeaders=" + Arrays.deepToString(this.getExposedHeaders()) + ")";
        }
    }
}

