/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config.reactive;

import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsSecurityProperties;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.security.authentication.ReactiveAuthenticationManagerResolver;
import org.springframework.security.config.annotation.method.configuration.EnableReactiveMethodSecurity;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.security.web.server.context.NoOpServerSecurityContextRepository;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.web.server.ServerWebExchange;

@Import(value={SpringAddonsSecurityProperties.class})
@EnableWebFluxSecurity
@EnableReactiveMethodSecurity
public class OidcReactiveApiSecurityConfig {
    private final ReactiveAuthenticationManagerResolver<ServerWebExchange> authenticationManagerResolver;
    private final SpringAddonsSecurityProperties securityProperties;
    private final ServerProperties serverProperties;

    @ConditionalOnMissingBean
    @Bean
    public SecurityWebFilterChain springSecurityFilterChain(ServerHttpSecurity http, ServerAccessDeniedHandler accessDeniedHandler) {
        http.oauth2ResourceServer().authenticationManagerResolver(this.authenticationManagerResolver);
        if (this.securityProperties.isAnonymousEnabled()) {
            http.anonymous();
        }
        if (this.securityProperties.getCors().length > 0) {
            http.cors();
        }
        if (!this.securityProperties.isCsrfEnabled()) {
            http.csrf().disable();
        }
        if (this.securityProperties.isStatlessSessions()) {
            http.securityContextRepository((ServerSecurityContextRepository)NoOpServerSecurityContextRepository.getInstance());
        }
        if (!this.securityProperties.isRedirectToLoginIfUnauthorizedOnRestrictedContent()) {
            http.exceptionHandling().accessDeniedHandler(accessDeniedHandler);
        }
        if (this.serverProperties.getSsl() != null && this.serverProperties.getSsl().isEnabled()) {
            http.redirectToHttps();
        }
        this.authorizeRequests(((ServerHttpSecurity.AuthorizeExchangeSpec.Access)http.authorizeExchange().pathMatchers(this.securityProperties.getPermitAll())).permitAll());
        return http.build();
    }

    protected ServerHttpSecurity.AuthorizeExchangeSpec authorizeRequests(ServerHttpSecurity.AuthorizeExchangeSpec spec) {
        return spec.anyExchange().authenticated();
    }

    @Generated
    public ReactiveAuthenticationManagerResolver<ServerWebExchange> getAuthenticationManagerResolver() {
        return this.authenticationManagerResolver;
    }

    @Generated
    public SpringAddonsSecurityProperties getSecurityProperties() {
        return this.securityProperties;
    }

    @Generated
    public ServerProperties getServerProperties() {
        return this.serverProperties;
    }

    @Generated
    public OidcReactiveApiSecurityConfig(ReactiveAuthenticationManagerResolver<ServerWebExchange> authenticationManagerResolver, SpringAddonsSecurityProperties securityProperties, ServerProperties serverProperties) {
        this.authenticationManagerResolver = authenticationManagerResolver;
        this.securityProperties = securityProperties;
        this.serverProperties = serverProperties;
    }
}

