/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config.reactive;

import com.c4_soft.springaddons.security.oauth2.ReactiveJwt2AuthenticationConverter;
import com.c4_soft.springaddons.security.oauth2.ReactiveJwt2GrantedAuthoritiesConverter;
import com.c4_soft.springaddons.security.oauth2.ReactiveJwt2OidcTokenConverter;
import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsSecurityProperties;
import com.c4_soft.springaddons.security.oauth2.config.reactive.ReactiveEmbeddedJwt2GrantedAuthoritiesConverter;
import com.c4_soft.springaddons.security.oauth2.oidc.OidcAuthentication;
import com.c4_soft.springaddons.security.oauth2.oidc.OidcToken;
import com.c4_soft.springaddons.security.oauth2.oidc.ReactiveJwt2OidcAuthenticationConverter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.ReactiveAuthenticationManagerResolver;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoders;
import org.springframework.security.oauth2.server.resource.authentication.JwtIssuerReactiveAuthenticationManagerResolver;
import org.springframework.security.oauth2.server.resource.authentication.JwtReactiveAuthenticationManager;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.cors.reactive.UrlBasedCorsConfigurationSource;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Configuration
@Import(value={SpringAddonsSecurityProperties.class})
public class ReactiveSecurityBeans {
    private final OAuth2ResourceServerProperties auth2ResourceServerProperties;
    private final SpringAddonsSecurityProperties securityProperties;

    @ConditionalOnMissingBean
    @Bean
    public <T extends OidcToken> ReactiveJwt2AuthenticationConverter<OidcAuthentication<T>> authenticationConverter(ReactiveJwt2GrantedAuthoritiesConverter authoritiesConverter, ReactiveJwt2OidcTokenConverter<T> tokenConverter) {
        return new ReactiveJwt2OidcAuthenticationConverter<T>(authoritiesConverter, tokenConverter);
    }

    @ConditionalOnMissingBean
    @Bean
    public ReactiveJwt2GrantedAuthoritiesConverter authoritiesConverter() {
        return new ReactiveEmbeddedJwt2GrantedAuthoritiesConverter(this.securityProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    public ReactiveJwt2OidcTokenConverter<OidcToken> tokenConverter() {
        return jwt -> Mono.just((Object)new OidcToken(jwt.getClaims()));
    }

    @ConditionalOnMissingBean
    @Bean
    public ReactiveAuthenticationManagerResolver<ServerWebExchange> authenticationManagerResolver() {
        Set locations = Stream.concat(Optional.of(this.auth2ResourceServerProperties.getJwt()).map(OAuth2ResourceServerProperties.Jwt::getIssuerUri).stream(), Stream.of(this.securityProperties.getAuthorizationServerLocations())).filter(l -> l != null && l.length() > 0).collect(Collectors.toSet());
        Map<String, Mono> managers = locations.stream().collect(Collectors.toMap(l -> l, l -> {
            ReactiveJwtDecoder decoder = ReactiveJwtDecoders.fromIssuerLocation((String)l);
            JwtReactiveAuthenticationManager provider = new JwtReactiveAuthenticationManager(decoder);
            provider.setJwtAuthenticationConverter(this.authenticationConverter(this.authoritiesConverter(), this.tokenConverter()));
            return Mono.just(arg_0 -> ((JwtReactiveAuthenticationManager)provider).authenticate(arg_0));
        }));
        return new JwtIssuerReactiveAuthenticationManagerResolver(managers::get);
    }

    @ConditionalOnMissingBean
    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        for (SpringAddonsSecurityProperties.CorsProperties corsProps : this.securityProperties.getCors()) {
            CorsConfiguration configuration = new CorsConfiguration();
            configuration.setAllowedOrigins(Arrays.asList(corsProps.getAllowedOrigins()));
            configuration.setAllowedMethods(Arrays.asList(corsProps.getAllowedMethods()));
            configuration.setAllowedHeaders(Arrays.asList(corsProps.getAllowedHeaders()));
            configuration.setExposedHeaders(Arrays.asList(corsProps.getExposedHeaders()));
            source.registerCorsConfiguration(corsProps.getPath(), configuration);
        }
        return source;
    }

    @ConditionalOnMissingBean
    @Bean
    public ServerAccessDeniedHandler serverAccessDeniedHandler() {
        return (exchange, ex) -> exchange.getPrincipal().flatMap(principal -> {
            ServerHttpResponse response = exchange.getResponse();
            response.setStatusCode(principal instanceof AnonymousAuthenticationToken ? HttpStatus.UNAUTHORIZED : HttpStatus.FORBIDDEN);
            response.getHeaders().setContentType(MediaType.TEXT_PLAIN);
            DataBufferFactory dataBufferFactory = response.bufferFactory();
            DataBuffer buffer = dataBufferFactory.wrap(ex.getMessage().getBytes(Charset.defaultCharset()));
            return response.writeWith((Publisher)Mono.just((Object)buffer)).doOnError(error -> DataBufferUtils.release((DataBuffer)buffer));
        });
    }

    @Generated
    public ReactiveSecurityBeans(OAuth2ResourceServerProperties auth2ResourceServerProperties, SpringAddonsSecurityProperties securityProperties) {
        this.auth2ResourceServerProperties = auth2ResourceServerProperties;
        this.securityProperties = securityProperties;
    }
}

