/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config.synchronised;

import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsSecurityProperties;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;

@Import(value={SpringAddonsSecurityProperties.class})
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class OidcServletApiSecurityConfig
extends WebSecurityConfigurerAdapter {
    private final AuthenticationManagerResolver<HttpServletRequest> authenticationManagerResolver;
    private final SpringAddonsSecurityProperties securityProperties;
    private final ServerProperties serverProperties;

    protected void configure(HttpSecurity http) throws Exception {
        http.oauth2ResourceServer(oauth2 -> oauth2.authenticationManagerResolver(this.authenticationManagerResolver));
        if (this.securityProperties.isAnonymousEnabled()) {
            http.anonymous();
        }
        if (this.securityProperties.getCors().length > 0) {
            http.cors();
        }
        if (!this.securityProperties.isCsrfEnabled()) {
            http.csrf().disable();
        }
        if (this.securityProperties.isStatlessSessions()) {
            http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        }
        if (!this.securityProperties.isRedirectToLoginIfUnauthorizedOnRestrictedContent()) {
            http.exceptionHandling().authenticationEntryPoint((request, response, authException) -> {
                response.addHeader("WWW-Authenticate", "Basic realm=\"Restricted Content\"");
                response.sendError(HttpStatus.UNAUTHORIZED.value(), HttpStatus.UNAUTHORIZED.getReasonPhrase());
            });
        }
        if (this.serverProperties.getSsl() != null && this.serverProperties.getSsl().isEnabled()) {
            ((ChannelSecurityConfigurer.RequiresChannelUrl)http.requiresChannel().anyRequest()).requiresSecure();
        } else {
            ((ChannelSecurityConfigurer.RequiresChannelUrl)http.requiresChannel().anyRequest()).requiresInsecure();
        }
        this.authorizeRequests(((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(this.securityProperties.getPermitAll())).permitAll());
    }

    protected ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry authorizeRequests(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry registry) {
        return ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.anyRequest()).authenticated();
    }

    @Generated
    public AuthenticationManagerResolver<HttpServletRequest> getAuthenticationManagerResolver() {
        return this.authenticationManagerResolver;
    }

    @Generated
    public SpringAddonsSecurityProperties getSecurityProperties() {
        return this.securityProperties;
    }

    @Generated
    public ServerProperties getServerProperties() {
        return this.serverProperties;
    }

    @Generated
    public OidcServletApiSecurityConfig(AuthenticationManagerResolver<HttpServletRequest> authenticationManagerResolver, SpringAddonsSecurityProperties securityProperties, ServerProperties serverProperties) {
        this.authenticationManagerResolver = authenticationManagerResolver;
        this.securityProperties = securityProperties;
        this.serverProperties = serverProperties;
    }
}

