/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config.synchronised;

import com.c4_soft.springaddons.security.oauth2.SynchronizedJwt2AuthenticationConverter;
import com.c4_soft.springaddons.security.oauth2.SynchronizedJwt2GrantedAuthoritiesConverter;
import com.c4_soft.springaddons.security.oauth2.SynchronizedJwt2OidcTokenConverter;
import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsSecurityProperties;
import com.c4_soft.springaddons.security.oauth2.config.synchronised.SynchronizedEmbeddedJwt2GrantedAuthoritiesConverter;
import com.c4_soft.springaddons.security.oauth2.oidc.OidcAuthentication;
import com.c4_soft.springaddons.security.oauth2.oidc.OidcToken;
import com.c4_soft.springaddons.security.oauth2.oidc.SynchronizedJwt2OidcAuthenticationConverter;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoders;
import org.springframework.security.oauth2.jwt.SupplierJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.authentication.JwtIssuerAuthenticationManagerResolver;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@Import(value={SpringAddonsSecurityProperties.class})
public class ServletSecurityBeans {
    private final OAuth2ResourceServerProperties auth2ResourceServerProperties;
    private final SpringAddonsSecurityProperties securityProperties;

    @ConditionalOnMissingBean
    @Bean
    public <T extends OidcToken> SynchronizedJwt2AuthenticationConverter<OidcAuthentication<T>> authenticationConverter(SynchronizedJwt2GrantedAuthoritiesConverter authoritiesConverter, SynchronizedJwt2OidcTokenConverter<T> tokenConverter) {
        return new SynchronizedJwt2OidcAuthenticationConverter<T>(authoritiesConverter, tokenConverter);
    }

    @ConditionalOnMissingBean
    @Bean
    public SynchronizedJwt2GrantedAuthoritiesConverter authoritiesConverter() {
        return new SynchronizedEmbeddedJwt2GrantedAuthoritiesConverter(this.securityProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    public SynchronizedJwt2OidcTokenConverter<OidcToken> tokenConverter() {
        return jwt -> new OidcToken(jwt.getClaims());
    }

    @ConditionalOnMissingBean
    @Bean
    public JwtIssuerAuthenticationManagerResolver authenticationManagerResolver() {
        Set locations = Stream.concat(Optional.of(this.auth2ResourceServerProperties.getJwt()).map(OAuth2ResourceServerProperties.Jwt::getIssuerUri).stream(), Stream.of(this.securityProperties.getAuthorizationServerLocations())).filter(l -> l != null && l.length() > 0).collect(Collectors.toSet());
        Map<String, AuthenticationManager> managers = locations.stream().collect(Collectors.toMap(l -> l, l -> {
            SupplierJwtDecoder decoder = new SupplierJwtDecoder(() -> JwtDecoders.fromIssuerLocation((String)l));
            JwtAuthenticationProvider provider = new JwtAuthenticationProvider((JwtDecoder)decoder);
            provider.setJwtAuthenticationConverter(this.authenticationConverter(this.authoritiesConverter(), this.tokenConverter()));
            return arg_0 -> ((JwtAuthenticationProvider)provider).authenticate(arg_0);
        }));
        return new JwtIssuerAuthenticationManagerResolver(managers::get);
    }

    @ConditionalOnMissingBean
    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        for (SpringAddonsSecurityProperties.CorsProperties corsProps : this.securityProperties.getCors()) {
            CorsConfiguration configuration = new CorsConfiguration();
            configuration.setAllowedOrigins(Arrays.asList(corsProps.getAllowedOrigins()));
            configuration.setAllowedMethods(Arrays.asList(corsProps.getAllowedMethods()));
            configuration.setAllowedHeaders(Arrays.asList(corsProps.getAllowedHeaders()));
            configuration.setExposedHeaders(Arrays.asList(corsProps.getExposedHeaders()));
            source.registerCorsConfiguration(corsProps.getPath(), configuration);
        }
        return source;
    }

    @Generated
    public ServletSecurityBeans(OAuth2ResourceServerProperties auth2ResourceServerProperties, SpringAddonsSecurityProperties securityProperties) {
        this.auth2ResourceServerProperties = auth2ResourceServerProperties;
        this.securityProperties = securityProperties;
    }
}

