/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations;

import com.c4_soft.springaddons.security.oauth2.oidc.OidcIdAuthenticationToken;
import com.c4_soft.springaddons.security.oauth2.test.OidcIdAuthenticationTokenTestingBuilder;
import com.c4_soft.springaddons.security.oauth2.test.annotations.ClaimSet;
import com.c4_soft.springaddons.security.oauth2.test.annotations.IdTokenBuilderHelper;
import com.c4_soft.springaddons.security.oauth2.test.annotations.IdTokenClaims;
import com.c4_soft.springaddons.security.oauth2.test.annotations.IntClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.JsonArrayClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.JsonObjectClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.OidcIdBuilderHelper;
import com.c4_soft.springaddons.security.oauth2.test.annotations.OidcStandardClaims;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.MalformedURLException;
import java.util.Collection;
import org.springframework.core.annotation.AliasFor;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.test.context.support.TestExecutionEvent;
import org.springframework.security.test.context.support.WithSecurityContext;
import org.springframework.security.test.context.support.WithSecurityContextFactory;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Inherited
@Documented
@WithSecurityContext(factory=OidcIdAuthenticationTokenFactory.class)
public @interface WithMockOidcId {
    @AliasFor(value="authorities")
    public String[] value() default {};

    @AliasFor(value="value")
    public String[] authorities() default {};

    public IdTokenClaims id() default @IdTokenClaims;

    public OidcStandardClaims oidc() default @OidcStandardClaims;

    public ClaimSet privateClaims() default @ClaimSet;

    @AliasFor(annotation=WithSecurityContext.class)
    public TestExecutionEvent setupBefore() default TestExecutionEvent.TEST_METHOD;

    public static final class OidcIdAuthenticationTokenFactory
    extends OidcIdAuthenticationTokenTestingBuilder<OidcIdAuthenticationTokenFactory>
    implements WithSecurityContextFactory<WithMockOidcId> {
        public SecurityContext createSecurityContext(WithMockOidcId annotation) {
            SecurityContext context = SecurityContextHolder.createEmptyContext();
            try {
                context.setAuthentication((Authentication)this.authentication(annotation));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            return context;
        }

        public OidcIdAuthenticationToken authentication(WithMockOidcId annotation) throws MalformedURLException {
            IdTokenBuilderHelper.feed(this.tokenBuilder, annotation.id());
            OidcIdBuilderHelper.feed(this.tokenBuilder, annotation.oidc());
            for (IntClaim intClaim : annotation.privateClaims().intClaims()) {
                this.tokenBuilder.claim(intClaim.name(), (Object)intClaim.value());
            }
            for (Annotation annotation2 : annotation.privateClaims().longClaims()) {
                this.tokenBuilder.claim(annotation2.name(), (Object)annotation2.value());
            }
            for (Annotation annotation3 : annotation.privateClaims().stringClaims()) {
                this.tokenBuilder.claim(annotation3.name(), annotation3.value());
            }
            for (Annotation annotation4 : annotation.privateClaims().stringArrayClaims()) {
                this.tokenBuilder.claim(annotation4.name(), (Object)annotation4.value());
            }
            for (Annotation annotation5 : annotation.privateClaims().jsonObjectClaims()) {
                this.tokenBuilder.claim(annotation5.name(), (Object)JsonObjectClaim.Support.parse((JsonObjectClaim)annotation5));
            }
            for (Annotation annotation6 : annotation.privateClaims().jsonArrayClaims()) {
                this.tokenBuilder.claim(annotation6.name(), (Collection)JsonArrayClaim.Support.parse((JsonArrayClaim)annotation6));
            }
            if (annotation.authorities().length > 0) {
                this.authorities(annotation.authorities());
            }
            return this.build();
        }
    }
}

