/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations.keycloak;

import com.c4_soft.springaddons.security.oauth2.test.annotations.ClaimSet;
import com.c4_soft.springaddons.security.oauth2.test.annotations.IdTokenClaims;
import com.c4_soft.springaddons.security.oauth2.test.annotations.IntClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.JsonArrayClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.JsonObjectClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.OidcStandardClaims;
import com.c4_soft.springaddons.security.oauth2.test.annotations.WithAddress;
import java.lang.annotation.Annotation;
import java.time.Instant;
import org.keycloak.representations.AddressClaimSet;
import org.keycloak.representations.IDToken;
import org.springframework.util.StringUtils;

class IDTokenBuilderHelper {
    IDTokenBuilderHelper() {
    }

    public static IDToken feed(IDToken token, IdTokenClaims idTokenAnnotation, OidcStandardClaims oidcIdAnnotation, ClaimSet otherClaims) {
        token.setAcr(idTokenAnnotation.acr());
        token.audience(idTokenAnnotation.aud());
        if (StringUtils.hasLength((String)idTokenAnnotation.authTime())) {
            token.setAuth_time(Long.valueOf(Instant.parse(idTokenAnnotation.authTime()).getEpochSecond()));
        }
        token.issuedFor(idTokenAnnotation.azp());
        if (StringUtils.hasLength((String)idTokenAnnotation.exp())) {
            token.exp(Long.valueOf(Instant.parse(idTokenAnnotation.exp()).getEpochSecond()));
        }
        if (StringUtils.hasLength((String)idTokenAnnotation.iat())) {
            token.iat(Long.valueOf(Instant.parse(idTokenAnnotation.iat()).getEpochSecond()));
        }
        if (StringUtils.hasText((String)idTokenAnnotation.iss())) {
            token.issuer(idTokenAnnotation.iss());
        }
        if (StringUtils.hasText((String)idTokenAnnotation.jti())) {
            token.id(idTokenAnnotation.jti());
        }
        if (StringUtils.hasText((String)idTokenAnnotation.nbf())) {
            token.nbf(Long.valueOf(Instant.parse(idTokenAnnotation.nbf()).getEpochSecond()));
        }
        token.setNonce(idTokenAnnotation.nonce());
        token.setSessionState(IDTokenBuilderHelper.nullIfEmpty(idTokenAnnotation.sessionState()));
        token.subject(idTokenAnnotation.sub());
        if (StringUtils.hasLength((String)oidcIdAnnotation.updatedAt())) {
            token.setUpdatedAt(Long.valueOf(Instant.parse(oidcIdAnnotation.updatedAt()).getEpochSecond()));
        }
        token.setAddress(IDTokenBuilderHelper.build(oidcIdAnnotation.address()));
        token.setBirthdate(IDTokenBuilderHelper.nullIfEmpty(oidcIdAnnotation.birthdate()));
        token.setEmail(IDTokenBuilderHelper.nullIfEmpty(oidcIdAnnotation.email()));
        token.setEmailVerified(Boolean.valueOf(oidcIdAnnotation.emailVerified()));
        token.setFamilyName(IDTokenBuilderHelper.nullIfEmpty(oidcIdAnnotation.familyName()));
        token.setGender(IDTokenBuilderHelper.nullIfEmpty(oidcIdAnnotation.gender()));
        token.setGivenName(IDTokenBuilderHelper.nullIfEmpty(oidcIdAnnotation.givenName()));
        token.setLocale(IDTokenBuilderHelper.nullIfEmpty(oidcIdAnnotation.locale()));
        token.setMiddleName(IDTokenBuilderHelper.nullIfEmpty(oidcIdAnnotation.middleName()));
        token.setName(IDTokenBuilderHelper.nullIfEmpty(oidcIdAnnotation.name()));
        token.setNickName(IDTokenBuilderHelper.nullIfEmpty(oidcIdAnnotation.nickName()));
        token.setPhoneNumber(IDTokenBuilderHelper.nullIfEmpty(oidcIdAnnotation.phoneNumber()));
        token.setPhoneNumberVerified(Boolean.valueOf(oidcIdAnnotation.phoneNumberVerified()));
        token.setPreferredUsername(IDTokenBuilderHelper.nullIfEmpty(oidcIdAnnotation.preferredUsername()));
        token.setPicture(IDTokenBuilderHelper.nullIfEmpty(oidcIdAnnotation.picture()));
        token.setProfile(IDTokenBuilderHelper.nullIfEmpty(oidcIdAnnotation.profile()));
        token.setWebsite(IDTokenBuilderHelper.nullIfEmpty(oidcIdAnnotation.website()));
        for (IntClaim intClaim : otherClaims.intClaims()) {
            token.setOtherClaims(intClaim.name(), (Object)intClaim.value());
        }
        for (Annotation annotation : otherClaims.longClaims()) {
            token.setOtherClaims(annotation.name(), (Object)annotation.value());
        }
        for (Annotation annotation : otherClaims.stringClaims()) {
            token.setOtherClaims(annotation.name(), (Object)annotation.value());
        }
        for (Annotation annotation : otherClaims.stringArrayClaims()) {
            token.setOtherClaims(annotation.name(), (Object)annotation.value());
        }
        for (Annotation annotation : otherClaims.jsonObjectClaims()) {
            token.setOtherClaims(annotation.name(), (Object)JsonObjectClaim.Support.parse((JsonObjectClaim)annotation));
        }
        for (Annotation annotation : otherClaims.jsonArrayClaims()) {
            token.setOtherClaims(annotation.name(), (Object)JsonArrayClaim.Support.parse((JsonArrayClaim)annotation));
        }
        return token;
    }

    private static AddressClaimSet build(WithAddress addressAnnotation) {
        AddressClaimSet claims = new AddressClaimSet();
        claims.setCountry(IDTokenBuilderHelper.nullIfEmpty(addressAnnotation.country()));
        claims.setFormattedAddress(IDTokenBuilderHelper.nullIfEmpty(addressAnnotation.formattedAddress()));
        claims.setLocality(IDTokenBuilderHelper.nullIfEmpty(addressAnnotation.locality()));
        claims.setPostalCode(IDTokenBuilderHelper.nullIfEmpty(addressAnnotation.postalCode()));
        claims.setRegion(IDTokenBuilderHelper.nullIfEmpty(addressAnnotation.region()));
        claims.setStreetAddress(IDTokenBuilderHelper.nullIfEmpty(addressAnnotation.streetAddress()));
        return claims;
    }

    private static String nullIfEmpty(String str) {
        return StringUtils.hasText((String)str) ? str : null;
    }
}

