/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.keycloak;

import com.c4_soft.springaddons.security.oauth2.test.keycloak.KeycloakAuthenticationTokenBuilder;
import java.security.Principal;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.spi.KeycloakAccount;
import org.keycloak.adapters.springsecurity.account.SimpleKeycloakAccount;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;

public class KeycloakAuthenticationTokenTestingBuilder<T extends KeycloakAuthenticationTokenTestingBuilder<T>>
extends KeycloakAuthenticationTokenBuilder<T> {
    private KeycloakDeployment keycloakDeployment = null;
    private final AccessToken accessToken = new AccessToken();
    private String accessTokenString = "test.keycloak.token";
    private IDToken idToken = null;
    private String idTokenString = null;
    private String refreshTokenString = null;
    private final GrantedAuthoritiesMapper authoritiesMapper;

    public KeycloakAuthenticationTokenTestingBuilder(Optional<GrantedAuthoritiesMapper> authoritiesMapper) {
        this.authoritiesMapper = authoritiesMapper.orElse((GrantedAuthoritiesMapper)new NullAuthoritiesMapper());
        this.accessToken.setRealmAccess(new AccessToken.Access());
        this.accessToken.setPreferredUsername("user");
        this.authorities("offline_access", "uma_authorization");
    }

    public void keycloakDeployment(KeycloakDeployment keycloakDeployment) {
        this.keycloakDeployment = keycloakDeployment;
    }

    public T authorities(Stream<String> authorities) {
        Set authoritiesSet = authorities.collect(Collectors.toSet());
        this.accessToken.getRealmAccess().roles(authoritiesSet);
        super.authorities(this.authoritiesMapper.mapAuthorities((Collection)authoritiesSet.stream().map(SimpleGrantedAuthority::new).collect(Collectors.toSet())));
        return (T)((KeycloakAuthenticationTokenTestingBuilder)this.downcast());
    }

    public T authorities(String ... authorities) {
        return this.authorities(Stream.of(authorities));
    }

    public T accessToken(Consumer<AccessToken> token) {
        token.accept(this.accessToken);
        return (T)((KeycloakAuthenticationTokenTestingBuilder)this.downcast());
    }

    public T idToken(Consumer<IDToken> token) {
        if (this.idToken == null) {
            this.idToken = new IDToken();
        }
        token.accept(this.idToken);
        return (T)((KeycloakAuthenticationTokenTestingBuilder)this.downcast());
    }

    public T idToken(IDToken token) {
        this.idToken = token;
        return (T)((KeycloakAuthenticationTokenTestingBuilder)this.downcast());
    }

    public T tokenString(String tokenString) {
        this.accessTokenString = tokenString;
        return (T)((KeycloakAuthenticationTokenTestingBuilder)this.downcast());
    }

    public T idTokenString(String idTokenString) {
        this.idTokenString = idTokenString;
        return (T)((KeycloakAuthenticationTokenTestingBuilder)this.downcast());
    }

    public T refreshTokenString(String refreshTokenString) {
        this.refreshTokenString = refreshTokenString;
        return (T)((KeycloakAuthenticationTokenTestingBuilder)this.downcast());
    }

    @Override
    public KeycloakAuthenticationToken build() {
        RefreshableKeycloakSecurityContext securityContext = new RefreshableKeycloakSecurityContext(this.keycloakDeployment, null, this.accessTokenString, this.accessToken, this.idTokenString == null ? this.accessTokenString : this.idTokenString, (IDToken)(this.idToken == null ? this.accessToken : this.idToken), this.refreshTokenString);
        KeycloakPrincipal principal = new KeycloakPrincipal(this.accessToken.getPreferredUsername(), (KeycloakSecurityContext)securityContext);
        SimpleKeycloakAccount account = new SimpleKeycloakAccount((Principal)principal, this.accessToken.getRealmAccess().getRoles(), securityContext);
        return new KeycloakAuthenticationToken((KeycloakAccount)account, this.isInteractive, (Collection)this.authorities);
    }
}

