/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations;

import com.c4_soft.springaddons.security.oauth2.oidc.IdTokenBuilder;
import com.c4_soft.springaddons.security.oauth2.test.annotations.IdTokenClaims;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.Arrays;
import org.springframework.util.StringUtils;

class IdTokenBuilderHelper {
    IdTokenBuilderHelper() {
    }

    static <T extends IdTokenBuilder<T>> T feed(T token, IdTokenClaims tokenAnnotation) throws MalformedURLException {
        if (StringUtils.hasLength((String)tokenAnnotation.authTime())) {
            token.authTime(Instant.parse(tokenAnnotation.authTime()));
        }
        if (StringUtils.hasLength((String)tokenAnnotation.exp())) {
            token.expiresAt(Instant.parse(tokenAnnotation.exp()));
        }
        if (StringUtils.hasLength((String)tokenAnnotation.iat())) {
            token.issuedAt(Instant.parse(tokenAnnotation.iat()));
        }
        if (StringUtils.hasText((String)tokenAnnotation.iss())) {
            token.issuer(new URL(tokenAnnotation.iss()));
        }
        if (StringUtils.hasLength((String)tokenAnnotation.jti())) {
            token.jwtId(tokenAnnotation.jti());
        }
        if (StringUtils.hasLength((String)tokenAnnotation.nbf())) {
            token.notBefore(Instant.parse(tokenAnnotation.nbf()));
        }
        if (StringUtils.hasLength((String)tokenAnnotation.sessionState())) {
            token.sessionState(tokenAnnotation.sessionState());
        }
        return (T)token.subject(tokenAnnotation.sub()).audience(Arrays.asList(tokenAnnotation.aud())).nonce(tokenAnnotation.nonce()).acr(tokenAnnotation.acr()).amr(Arrays.asList(tokenAnnotation.amr())).azp(tokenAnnotation.azp());
    }
}

