/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test;

import com.c4_soft.springaddons.security.oauth2.ModifiableClaimSet;
import com.c4_soft.springaddons.security.oauth2.oidc.OidcToken;
import java.net.URL;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class OidcTokenBuilder
extends ModifiableClaimSet {
    private static final long serialVersionUID = 8050195176203128543L;

    public OidcTokenBuilder() {
    }

    public OidcTokenBuilder(Map<String, Object> ptivateClaims) {
        super(ptivateClaims);
    }

    public OidcToken build() {
        return new OidcToken((Map)((Object)this));
    }

    public OidcTokenBuilder acr(String acr) {
        return this.setIfNonEmpty("acr", acr);
    }

    public OidcTokenBuilder amr(List<String> amr) {
        return this.setIfNonEmpty("amr", amr);
    }

    public OidcTokenBuilder audience(List<String> audience) {
        return this.setIfNonEmpty("aud", audience);
    }

    public OidcTokenBuilder authTime(Instant authTime) {
        return this.setIfNonEmpty("auth_time", authTime);
    }

    public OidcTokenBuilder azp(String azp) {
        return this.setIfNonEmpty("azp", azp);
    }

    public OidcTokenBuilder expiresAt(Instant expiresAt) {
        return this.setIfNonEmpty("exp", expiresAt);
    }

    public OidcTokenBuilder issuedAt(Instant issuedAt) {
        return this.setIfNonEmpty("iat", issuedAt);
    }

    public OidcTokenBuilder jwtId(String jti) {
        return this.setIfNonEmpty("jti", jti);
    }

    public OidcTokenBuilder issuer(URL issuer) {
        return this.setIfNonEmpty("iss", issuer.toString());
    }

    public OidcTokenBuilder nonce(String nonce) {
        return this.setIfNonEmpty("nonce", nonce);
    }

    public OidcTokenBuilder notBefore(Instant nbf) {
        return this.setIfNonEmpty("nbf", nbf);
    }

    public OidcTokenBuilder accessTokenHash(String atHash) {
        return this.setIfNonEmpty("at_hash", atHash);
    }

    public OidcTokenBuilder authorizationCodeHash(String cHash) {
        return this.setIfNonEmpty("c_hash", cHash);
    }

    public OidcTokenBuilder sessionState(String sessionState) {
        return this.setIfNonEmpty("session_state", sessionState);
    }

    public OidcTokenBuilder subject(String subject) {
        return this.setIfNonEmpty("sub", subject);
    }

    public OidcTokenBuilder name(String value) {
        return this.setIfNonEmpty("name", value);
    }

    public OidcTokenBuilder givenName(String value) {
        return this.setIfNonEmpty("given_name", value);
    }

    public OidcTokenBuilder familyName(String value) {
        return this.setIfNonEmpty("family_name", value);
    }

    public OidcTokenBuilder middleName(String value) {
        return this.setIfNonEmpty("middle_name", value);
    }

    public OidcTokenBuilder nickname(String value) {
        return this.setIfNonEmpty("nickname", value);
    }

    public OidcTokenBuilder preferredUsername(String value) {
        return this.setIfNonEmpty("preferred_username", value);
    }

    public OidcTokenBuilder profile(String value) {
        return this.setIfNonEmpty("profile", value);
    }

    public OidcTokenBuilder picture(String value) {
        return this.setIfNonEmpty("picture", value);
    }

    public OidcTokenBuilder website(String value) {
        return this.setIfNonEmpty("website", value);
    }

    public OidcTokenBuilder email(String value) {
        return this.setIfNonEmpty("email", value);
    }

    public OidcTokenBuilder emailVerified(Boolean value) {
        return this.setIfNonEmpty("email_verified", value);
    }

    public OidcTokenBuilder gender(String value) {
        return this.setIfNonEmpty("gender", value);
    }

    public OidcTokenBuilder birthdate(String value) {
        return this.setIfNonEmpty("birthdate", value);
    }

    public OidcTokenBuilder zoneinfo(String value) {
        return this.setIfNonEmpty("zoneinfo", value);
    }

    public OidcTokenBuilder locale(String value) {
        return this.setIfNonEmpty("locale", value);
    }

    public OidcTokenBuilder phoneNumber(String value) {
        return this.setIfNonEmpty("phone_number", value);
    }

    public OidcTokenBuilder phoneNumberVerified(Boolean value) {
        return this.setIfNonEmpty("phone_number_verified", value);
    }

    public OidcTokenBuilder address(AddressClaim value) {
        if (value == null) {
            this.remove("address");
        } else {
            this.put("address", (Object)value);
        }
        return this;
    }

    public OidcTokenBuilder claims(Map<String, Object> claims) {
        this.putAll(claims);
        return this;
    }

    public OidcTokenBuilder privateClaims(Map<String, Object> claims) {
        return this.claims(claims);
    }

    public OidcTokenBuilder otherClaims(Map<String, Object> claims) {
        return this.claims(claims);
    }

    public OidcTokenBuilder updatedAt(Instant value) {
        return this.setIfNonEmpty("", value);
    }

    protected OidcTokenBuilder setIfNonEmpty(String claimName, String claimValue) {
        if (StringUtils.hasText((String)claimValue)) {
            this.put(claimName, claimValue);
        } else {
            this.remove(claimName);
        }
        return this;
    }

    protected OidcTokenBuilder setIfNonEmpty(String claimName, Collection<String> claimValue) {
        if (claimValue == null || claimValue.size() == 0) {
            this.remove(claimName);
        } else if (claimValue.size() == 0) {
            this.setIfNonEmpty(claimName, claimValue.iterator().next());
        } else {
            this.put(claimName, claimValue);
        }
        return this;
    }

    protected OidcTokenBuilder setIfNonEmpty(String claimName, Instant claimValue) {
        if (claimValue == null) {
            this.remove(claimName);
        } else {
            this.put(claimName, claimValue.getEpochSecond());
        }
        return this;
    }

    protected OidcTokenBuilder setIfNonEmpty(String claimName, Boolean claimValue) {
        if (claimValue == null) {
            this.remove(claimName);
        } else {
            this.put(claimName, claimValue);
        }
        return this;
    }

    public static final class AddressClaim
    extends ModifiableClaimSet {
        private static final long serialVersionUID = 28800769851008900L;

        public AddressClaim formatted(String value) {
            return this.setIfNonEmpty("formatted", value);
        }

        public AddressClaim streetAddress(String value) {
            return this.setIfNonEmpty("street_address", value);
        }

        public AddressClaim locality(String value) {
            return this.setIfNonEmpty("locality", value);
        }

        public AddressClaim region(String value) {
            return this.setIfNonEmpty("region", value);
        }

        public AddressClaim postalCode(String value) {
            return this.setIfNonEmpty("postal_code", value);
        }

        public AddressClaim country(String value) {
            return this.setIfNonEmpty("country", value);
        }

        private AddressClaim setIfNonEmpty(String claimName, String claimValue) {
            if (StringUtils.hasText((String)claimValue)) {
                this.put(claimName, claimValue);
            } else {
                this.remove(claimName);
            }
            return this;
        }
    }
}

