/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations.keycloak;

import com.c4_soft.springaddons.security.oauth2.test.annotations.OpenIdClaims;
import com.c4_soft.springaddons.security.oauth2.test.annotations.keycloak.AccessTokenBuilderHelper;
import com.c4_soft.springaddons.security.oauth2.test.annotations.keycloak.IDTokenBuilderHelper;
import com.c4_soft.springaddons.security.oauth2.test.annotations.keycloak.KeycloakAccess;
import com.c4_soft.springaddons.security.oauth2.test.annotations.keycloak.KeycloakAccessToken;
import com.c4_soft.springaddons.security.oauth2.test.annotations.keycloak.KeycloakResourceAccess;
import com.c4_soft.springaddons.security.oauth2.test.keycloak.KeycloakAuthenticationTokenTestingBuilder;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;
import java.util.stream.Stream;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AliasFor;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.test.context.support.TestExecutionEvent;
import org.springframework.security.test.context.support.WithSecurityContext;
import org.springframework.security.test.context.support.WithSecurityContextFactory;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Inherited
@Documented
@WithSecurityContext(factory=Factory.class)
public @interface WithMockKeycloakAuth {
    @AliasFor(value="authorities")
    public String[] value() default {"offline_access", "uma_authorization"};

    @AliasFor(value="value")
    public String[] authorities() default {"offline_access", "uma_authorization"};

    public KeycloakAccessToken accessToken() default @KeycloakAccessToken;

    public OpenIdClaims claims() default @OpenIdClaims;

    public boolean isInteractive() default false;

    @AliasFor(annotation=WithSecurityContext.class)
    public TestExecutionEvent setupBefore() default TestExecutionEvent.TEST_METHOD;

    public static final class Factory
    implements WithSecurityContextFactory<WithMockKeycloakAuth> {
        private final KeycloakAuthenticationTokenTestingBuilder<?> builder;

        @Autowired
        public Factory(Optional<GrantedAuthoritiesMapper> authoritiesMapper) {
            this.builder = new KeycloakAuthenticationTokenTestingBuilder(authoritiesMapper);
        }

        @Autowired(required=false)
        public void setKeycloakDeployment(KeycloakDeployment keycloakDeployment) {
            this.builder.keycloakDeployment(keycloakDeployment);
        }

        public SecurityContext createSecurityContext(WithMockKeycloakAuth annotation) {
            SecurityContext context = SecurityContextHolder.createEmptyContext();
            context.setAuthentication((Authentication)this.authentication(annotation));
            return context;
        }

        public KeycloakAuthenticationToken authentication(WithMockKeycloakAuth annotation) {
            return ((KeycloakAuthenticationTokenTestingBuilder)((KeycloakAuthenticationTokenTestingBuilder)((KeycloakAuthenticationTokenTestingBuilder)((KeycloakAuthenticationTokenTestingBuilder)this.builder.isIntercative(annotation.isInteractive())).accessToken(accessToken -> AccessTokenBuilderHelper.feed(accessToken, annotation))).idToken(idToken -> IDTokenBuilderHelper.feed(idToken, annotation.claims()))).authorities(Stream.concat(Stream.concat(Stream.of(annotation.authorities()), Stream.of(annotation.accessToken().realmAccess().roles())), Stream.of(annotation.accessToken().resourceAccess()).map(KeycloakResourceAccess::access).map(KeycloakAccess::roles).flatMap(Stream::of)))).build();
        }
    }
}

