/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations;

import com.c4_soft.springaddons.security.oauth2.oidc.OidcToken;
import com.c4_soft.springaddons.security.oauth2.test.OidcTokenBuilder;
import com.c4_soft.springaddons.security.oauth2.test.annotations.Claims;
import com.c4_soft.springaddons.security.oauth2.test.annotations.OpenIdAddress;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import org.springframework.util.StringUtils;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface OpenIdClaims {
    public String acr() default "";

    public String[] amr() default {};

    public String[] aud() default {};

    public String azp() default "";

    public String authTime() default "";

    public String exp() default "";

    public String iat() default "";

    public String jti() default "";

    public String nbf() default "";

    public String iss() default "";

    public String nonce() default "";

    public String sub() default "user";

    public String sessionState() default "";

    public String accessTokenHash() default "";

    public String authorizationCodeHash() default "";

    public OpenIdAddress address() default @OpenIdAddress;

    public String birthdate() default "";

    public String email() default "";

    public boolean emailVerified() default false;

    public String familyName() default "";

    public String gender() default "";

    public String givenName() default "";

    public String locale() default "";

    public String middleName() default "";

    public String name() default "";

    public String nickName() default "";

    public String phoneNumber() default "";

    public boolean phoneNumberVerified() default false;

    public String picture() default "";

    public String preferredUsername() default "user";

    public String profile() default "";

    public String updatedAt() default "";

    public String website() default "";

    public String zoneinfo() default "";

    public Claims otherClaims() default @Claims;

    public static class Token {
        public static OidcToken of(OpenIdClaims tokenAnnotation) {
            OidcTokenBuilder token = new OidcTokenBuilder((Map<String, Object>)Claims.Token.of(tokenAnnotation.otherClaims()));
            if (StringUtils.hasText((String)tokenAnnotation.iss())) {
                try {
                    token.issuer(new URL(tokenAnnotation.iss()));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            if (StringUtils.hasLength((String)tokenAnnotation.exp())) {
                token.expiresAt(Instant.parse(tokenAnnotation.exp()));
            }
            if (StringUtils.hasLength((String)tokenAnnotation.iat())) {
                token.issuedAt(Instant.parse(tokenAnnotation.iat()));
            }
            if (StringUtils.hasLength((String)tokenAnnotation.authTime())) {
                token.authTime(Instant.parse(tokenAnnotation.authTime()));
            }
            if (StringUtils.hasLength((String)tokenAnnotation.sessionState())) {
                token.sessionState(tokenAnnotation.sessionState());
            }
            if (StringUtils.hasLength((String)tokenAnnotation.sessionState())) {
                token.accessTokenHash(tokenAnnotation.accessTokenHash());
            }
            if (StringUtils.hasLength((String)tokenAnnotation.sessionState())) {
                token.authorizationCodeHash(tokenAnnotation.authorizationCodeHash());
            }
            token.subject(tokenAnnotation.sub()).audience(Arrays.asList(tokenAnnotation.aud())).nonce(tokenAnnotation.nonce()).acr(tokenAnnotation.acr()).amr(Arrays.asList(tokenAnnotation.amr())).azp(tokenAnnotation.azp());
            if (StringUtils.hasLength((String)tokenAnnotation.updatedAt())) {
                token.updatedAt(Instant.parse(tokenAnnotation.updatedAt()));
            }
            return token.address(OpenIdAddress.Claim.of(tokenAnnotation.address())).birthdate(Token.nullIfEmpty(tokenAnnotation.birthdate())).email(Token.nullIfEmpty(tokenAnnotation.email())).emailVerified(tokenAnnotation.emailVerified()).familyName(Token.nullIfEmpty(tokenAnnotation.familyName())).gender(Token.nullIfEmpty(tokenAnnotation.gender())).givenName(Token.nullIfEmpty(tokenAnnotation.givenName())).jwtId(tokenAnnotation.jti()).locale(Token.nullIfEmpty(tokenAnnotation.locale())).middleName(Token.nullIfEmpty(tokenAnnotation.middleName())).name(Token.nullIfEmpty(tokenAnnotation.name())).nickname(Token.nullIfEmpty(tokenAnnotation.nickName())).phoneNumber(Token.nullIfEmpty(tokenAnnotation.phoneNumber())).phoneNumberVerified(tokenAnnotation.phoneNumberVerified()).preferredUsername(Token.nullIfEmpty(tokenAnnotation.preferredUsername())).picture(Token.nullIfEmpty(tokenAnnotation.picture())).profile(Token.nullIfEmpty(tokenAnnotation.profile())).website(Token.nullIfEmpty(tokenAnnotation.website())).build();
        }

        private static String nullIfEmpty(String str) {
            return StringUtils.hasText((String)str) ? str : null;
        }
    }
}

