/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations;

import com.c4_soft.springaddons.security.oauth2.oidc.OidcAuthentication;
import com.c4_soft.springaddons.security.oauth2.oidc.OidcToken;
import com.c4_soft.springaddons.security.oauth2.test.annotations.AbstractAnnotatedAuthenticationBuilder;
import com.c4_soft.springaddons.security.oauth2.test.annotations.OpenIdClaims;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.core.annotation.AliasFor;
import org.springframework.security.test.context.support.TestExecutionEvent;
import org.springframework.security.test.context.support.WithSecurityContext;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Inherited
@Documented
@WithSecurityContext(factory=OidcIdAuthenticationFactory.class)
public @interface WithMockOidcAuth {
    @AliasFor(value="authorities")
    public String[] value() default {"ROLE_USER"};

    @AliasFor(value="value")
    public String[] authorities() default {"ROLE_USER"};

    public OpenIdClaims claims() default @OpenIdClaims;

    public String bearerString() default "machin.truc.chose";

    @AliasFor(annotation=WithSecurityContext.class)
    public TestExecutionEvent setupBefore() default TestExecutionEvent.TEST_METHOD;

    public static final class OidcIdAuthenticationFactory
    extends AbstractAnnotatedAuthenticationBuilder<WithMockOidcAuth, OidcAuthentication> {
        @Override
        public OidcAuthentication authentication(WithMockOidcAuth annotation) {
            OidcToken token = OpenIdClaims.Token.of(annotation.claims());
            return new OidcAuthentication(token, this.authorities(annotation.authorities()), annotation.bearerString());
        }
    }
}

