/*
 * Copyright 2020 Jérôme Wacongne
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.c4_soft.springaddons.security.oauth2.test.mockmvc;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import java.util.Collection;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;

import com.c4_soft.springaddons.security.oauth2.test.Defaults;

@TestConfiguration
@Order(Ordered.LOWEST_PRECEDENCE)
public class JwtTestConf {

	@ConditionalOnMissingBean
	@Bean
	public JwtDecoder jwtDecoder() {
		return mock(JwtDecoder.class);
	}

	@ConditionalOnMissingBean
	@Bean
	Converter<Jwt, Collection<GrantedAuthority>> authoritiesConverter() {
		final var conv = mock(IJwtGrantedAuthoritiesConverter.class);
		when(conv.convert(any(Jwt.class))).thenReturn(Defaults.GRANTED_AUTHORITIES);
		return conv;
	}

	public static interface IJwtGrantedAuthoritiesConverter extends Converter<Jwt, Collection<GrantedAuthority>> {
	}
}
