/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.mockmvc;

import com.c4_soft.springaddons.test.support.web.ByteArrayHttpOutputMessage;
import com.c4_soft.springaddons.test.support.web.SerializationHelper;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.test.context.TestComponent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.util.Assert;
import org.springframework.web.servlet.DispatcherServlet;

@TestComponent
@Import(value={SerializationHelper.class})
@Scope(value="prototype")
public class MockMvcSupport {
    private final MockMvc mockMvc;
    private final SerializationHelper conv;
    private MediaType mediaType;
    private Charset charset;
    private boolean isSecure;
    private final List<RequestPostProcessor> postProcessors;

    @Autowired
    public MockMvcSupport(MockMvc mockMvc, SerializationHelper serializationHelper, MockMvcProperties mockMvcProperties, ServerProperties serverProperties) {
        this.mockMvc = mockMvc;
        this.conv = serializationHelper;
        this.mediaType = MediaType.valueOf((String)mockMvcProperties.getDefaultMediaType());
        this.charset = Charset.forName(mockMvcProperties.getDefaultCharset());
        this.postProcessors = new ArrayList<RequestPostProcessor>();
        this.isSecure = serverProperties.getSsl() != null && serverProperties.getSsl().isEnabled();
    }

    public MockMvcSupport setSecure(boolean isSecure) {
        this.isSecure = isSecure;
        return this;
    }

    public MockMvcSupport setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public MockMvcSupport setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public MockHttpServletRequestBuilder requestBuilder(Optional<MediaType> accept, Optional<Charset> charset, HttpMethod method, String urlTemplate, Object ... uriVars) {
        MockHttpServletRequestBuilder builder = MockMvcRequestBuilders.request((HttpMethod)method, (String)urlTemplate, (Object[])uriVars);
        accept.ifPresent(xva$0 -> builder.accept(new MediaType[]{xva$0}));
        charset.ifPresent(c -> builder.characterEncoding(c.toString()));
        builder.secure(this.isSecure);
        return builder;
    }

    public ResultActions perform(MockHttpServletRequestBuilder requestBuilder) throws Exception {
        this.postProcessors.forEach(arg_0 -> ((MockHttpServletRequestBuilder)requestBuilder).with(arg_0));
        return this.mockMvc.perform((RequestBuilder)requestBuilder);
    }

    public MockHttpServletRequestBuilder getRequestBuilder(MediaType accept, String urlTemplate, Object ... uriVars) {
        return this.requestBuilder(Optional.of(accept), Optional.empty(), HttpMethod.GET, urlTemplate, uriVars);
    }

    public MockHttpServletRequestBuilder getRequestBuilder(String urlTemplate, Object ... uriVars) {
        return this.getRequestBuilder(this.mediaType, urlTemplate, uriVars);
    }

    public ResultActions get(MediaType accept, String urlTemplate, Object ... uriVars) throws Exception {
        return this.perform(this.getRequestBuilder(accept, urlTemplate, uriVars));
    }

    public ResultActions get(String urlTemplate, Object ... uriVars) throws Exception {
        return this.perform(this.getRequestBuilder(urlTemplate, uriVars));
    }

    public <T> MockHttpServletRequestBuilder postRequestBuilder(T payload, MediaType contentType, Charset charset, MediaType accept, String urlTemplate, Object ... uriVars) throws Exception {
        return this.feed(this.requestBuilder(Optional.of(accept), Optional.of(charset), HttpMethod.POST, urlTemplate, uriVars), payload, contentType, charset);
    }

    public <T> MockHttpServletRequestBuilder postRequestBuilder(T payload, MediaType contentType, MediaType accept, String urlTemplate, Object ... uriVars) throws Exception {
        return this.postRequestBuilder(payload, contentType, this.charset, accept, urlTemplate, uriVars);
    }

    public <T> MockHttpServletRequestBuilder postRequestBuilder(T payload, String urlTemplate, Object ... uriVars) throws Exception {
        return this.postRequestBuilder(payload, this.mediaType, this.charset, this.mediaType, urlTemplate, uriVars);
    }

    public <T> ResultActions post(T payload, MediaType contentType, Charset charset, MediaType accept, String urlTemplate, Object ... uriVars) throws Exception {
        return this.perform(this.postRequestBuilder(payload, contentType, charset, accept, urlTemplate, uriVars));
    }

    public <T> ResultActions post(T payload, MediaType contentType, MediaType accept, String urlTemplate, Object ... uriVars) throws Exception {
        return this.perform(this.postRequestBuilder(payload, contentType, accept, urlTemplate, uriVars));
    }

    public <T> ResultActions post(T payload, String urlTemplate, Object ... uriVars) throws Exception {
        return this.perform(this.postRequestBuilder(payload, urlTemplate, uriVars));
    }

    public <T> MockHttpServletRequestBuilder putRequestBuilder(T payload, MediaType contentType, Charset charset, String urlTemplate, Object ... uriVars) throws Exception {
        return this.feed(this.requestBuilder(Optional.empty(), Optional.of(charset), HttpMethod.PUT, urlTemplate, uriVars), payload, contentType, charset);
    }

    public <T> MockHttpServletRequestBuilder putRequestBuilder(T payload, MediaType contentType, String urlTemplate, Object ... uriVars) throws Exception {
        return this.putRequestBuilder(payload, contentType, this.charset, urlTemplate, uriVars);
    }

    public <T> MockHttpServletRequestBuilder putRequestBuilder(T payload, String urlTemplate, Object ... uriVars) throws Exception {
        return this.putRequestBuilder(payload, this.mediaType, this.charset, urlTemplate, uriVars);
    }

    public <T> ResultActions put(T payload, MediaType contentType, String charset, String urlTemplate, Object ... uriVars) throws Exception {
        return this.perform(this.putRequestBuilder(payload, contentType, charset, urlTemplate, uriVars));
    }

    public <T> ResultActions put(T payload, MediaType contentType, String urlTemplate, Object ... uriVars) throws Exception {
        return this.perform(this.putRequestBuilder(payload, contentType, urlTemplate, uriVars));
    }

    public <T> ResultActions put(T payload, String urlTemplate, Object ... uriVars) throws Exception {
        return this.perform(this.putRequestBuilder(payload, urlTemplate, uriVars));
    }

    public <T> MockHttpServletRequestBuilder patchRequestBuilder(T payload, MediaType contentType, Charset charset, String urlTemplate, Object ... uriVars) throws Exception {
        return this.feed(this.requestBuilder(Optional.empty(), Optional.of(charset), HttpMethod.PATCH, urlTemplate, uriVars), payload, contentType, charset);
    }

    public <T> MockHttpServletRequestBuilder patchRequestBuilder(T payload, MediaType contentType, String urlTemplate, Object ... uriVars) throws Exception {
        return this.patchRequestBuilder(payload, contentType, this.charset, urlTemplate, uriVars);
    }

    public <T> MockHttpServletRequestBuilder patchRequestBuilder(T payload, String urlTemplate, Object ... uriVars) throws Exception {
        return this.patchRequestBuilder(payload, this.mediaType, this.charset, urlTemplate, uriVars);
    }

    public <T> ResultActions patch(T payload, MediaType contentType, Charset charset, String urlTemplate, Object ... uriVars) throws Exception {
        return this.perform(this.patchRequestBuilder(payload, contentType, charset, urlTemplate, uriVars));
    }

    public <T> ResultActions patch(T payload, MediaType contentType, String urlTemplate, Object ... uriVars) throws Exception {
        return this.perform(this.patchRequestBuilder(payload, contentType, urlTemplate, uriVars));
    }

    public <T> ResultActions patch(T payload, String urlTemplate, Object ... uriVars) throws Exception {
        return this.perform(this.patchRequestBuilder(payload, urlTemplate, uriVars));
    }

    public MockHttpServletRequestBuilder deleteRequestBuilder(String urlTemplate, Object ... uriVars) {
        return this.requestBuilder(Optional.empty(), Optional.empty(), HttpMethod.DELETE, urlTemplate, uriVars);
    }

    public ResultActions delete(String urlTemplate, Object ... uriVars) throws Exception {
        return this.perform(this.deleteRequestBuilder(urlTemplate, uriVars));
    }

    public MockHttpServletRequestBuilder headRequestBuilder(String urlTemplate, Object ... uriVars) {
        return this.requestBuilder(Optional.empty(), Optional.empty(), HttpMethod.HEAD, urlTemplate, uriVars);
    }

    public ResultActions head(String urlTemplate, Object ... uriVars) throws Exception {
        return this.perform(this.headRequestBuilder(urlTemplate, uriVars));
    }

    public MockHttpServletRequestBuilder optionRequestBuilder(MediaType accept, String urlTemplate, Object ... uriVars) {
        return this.requestBuilder(Optional.of(accept), Optional.empty(), HttpMethod.OPTIONS, urlTemplate, uriVars);
    }

    public MockHttpServletRequestBuilder optionRequestBuilder(String urlTemplate, Object ... uriVars) {
        return this.optionRequestBuilder(this.mediaType, urlTemplate, uriVars);
    }

    public ResultActions option(MediaType accept, String urlTemplate, Object ... uriVars) throws Exception {
        return this.perform(this.optionRequestBuilder(accept, urlTemplate, uriVars));
    }

    public ResultActions option(String urlTemplate, Object ... uriVars) throws Exception {
        return this.perform(this.optionRequestBuilder(urlTemplate, uriVars));
    }

    public <T> MockHttpServletRequestBuilder feed(MockHttpServletRequestBuilder request, T payload, MediaType mediaType, Charset charset) throws Exception {
        if (payload == null) {
            return request;
        }
        ByteArrayHttpOutputMessage msg = this.conv.outputMessage(payload, new MediaType(mediaType, charset));
        return request.headers(msg.headers).content(msg.out.toByteArray());
    }

    public DispatcherServlet getDispatcherServlet() {
        return this.mockMvc.getDispatcherServlet();
    }

    public MockMvcSupport with(RequestPostProcessor postProcessor) {
        Assert.notNull((Object)postProcessor, (String)"postProcessor is required");
        this.postProcessors.add(postProcessor);
        return this;
    }

    @Configuration
    @ConfigurationProperties(prefix="com.c4-soft.springaddons.test.web")
    public static class MockMvcProperties {
        private String defaultMediaType = "application/json";
        private String defaultCharset = "utf-8";

        public String getDefaultMediaType() {
            return this.defaultMediaType;
        }

        public String getDefaultCharset() {
            return this.defaultCharset;
        }

        public void setDefaultMediaType(String defaultMediaType) {
            this.defaultMediaType = defaultMediaType;
        }

        public void setDefaultCharset(String defaultCharset) {
            this.defaultCharset = defaultCharset;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MockMvcProperties)) {
                return false;
            }
            MockMvcProperties other = (MockMvcProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$defaultMediaType = this.getDefaultMediaType();
            String other$defaultMediaType = other.getDefaultMediaType();
            if (this$defaultMediaType == null ? other$defaultMediaType != null : !this$defaultMediaType.equals(other$defaultMediaType)) {
                return false;
            }
            String this$defaultCharset = this.getDefaultCharset();
            String other$defaultCharset = other.getDefaultCharset();
            return !(this$defaultCharset == null ? other$defaultCharset != null : !this$defaultCharset.equals(other$defaultCharset));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MockMvcProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $defaultMediaType = this.getDefaultMediaType();
            result = result * 59 + ($defaultMediaType == null ? 43 : $defaultMediaType.hashCode());
            String $defaultCharset = this.getDefaultCharset();
            result = result * 59 + ($defaultCharset == null ? 43 : $defaultCharset.hashCode());
            return result;
        }

        public String toString() {
            return "MockMvcSupport.MockMvcProperties(defaultMediaType=" + this.getDefaultMediaType() + ", defaultCharset=" + this.getDefaultCharset() + ")";
        }
    }
}

