/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.mockmvc;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.test.web.support.WebTestUtils;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextRepository;

public class SecurityContextRequestPostProcessorSupport {
    private SecurityContextRequestPostProcessorSupport() {
    }

    public static final void save(Authentication authentication, HttpServletRequest request) {
        SecurityContext securityContext = SecurityContextHolder.createEmptyContext();
        securityContext.setAuthentication(authentication);
        SecurityContextRequestPostProcessorSupport.save(securityContext, request);
    }

    public static final void save(SecurityContext securityContext, HttpServletRequest request) {
        SecurityContextRepository securityContextRepository = WebTestUtils.getSecurityContextRepository((HttpServletRequest)request);
        boolean isTestRepository = securityContextRepository instanceof TestSecurityContextRepository;
        if (!isTestRepository) {
            securityContextRepository = new TestSecurityContextRepository(securityContextRepository);
            WebTestUtils.setSecurityContextRepository((HttpServletRequest)request, (SecurityContextRepository)securityContextRepository);
        }
        MockHttpServletResponse response = new MockHttpServletResponse();
        HttpRequestResponseHolder requestResponseHolder = new HttpRequestResponseHolder(request, (HttpServletResponse)response);
        securityContextRepository.loadContext(requestResponseHolder);
        request = requestResponseHolder.getRequest();
        response = requestResponseHolder.getResponse();
        securityContextRepository.saveContext(securityContext, request, (HttpServletResponse)response);
    }

    public static class TestSecurityContextRepository
    implements SecurityContextRepository {
        private static final String ATTR_NAME = TestSecurityContextRepository.class.getName().concat(".REPO");
        private final SecurityContextRepository delegate;

        private TestSecurityContextRepository(SecurityContextRepository delegate) {
            this.delegate = delegate;
        }

        public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
            SecurityContext result = TestSecurityContextRepository.getContext(requestResponseHolder.getRequest());
            SecurityContext delegateResult = this.delegate.loadContext(requestResponseHolder);
            return result == null ? delegateResult : result;
        }

        public void saveContext(SecurityContext context, HttpServletRequest request, HttpServletResponse response) {
            request.setAttribute(ATTR_NAME, (Object)context);
            this.delegate.saveContext(context, request, response);
        }

        public boolean containsContext(HttpServletRequest request) {
            return TestSecurityContextRepository.getContext(request) != null || this.delegate.containsContext(request);
        }

        public static SecurityContext getContext(HttpServletRequest request) {
            return (SecurityContext)request.getAttribute(ATTR_NAME);
        }
    }
}

